package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elastictranscoder.model.primitives.{Id, Ascending}
import scala.jdk.CollectionConverters.*
final case class ListPipelinesRequest(
    ascending: Optional[Ascending] = Optional.Absent,
    pageToken: Optional[Id] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.ListPipelinesRequest = {
    import ListPipelinesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.ListPipelinesRequest
      .builder()
      .optionallyWith(
        ascending.map(value => Ascending.unwrap(value): java.lang.String)
      )(_.ascending)
      .optionallyWith(
        pageToken.map(value => Id.unwrap(value): java.lang.String)
      )(_.pageToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elastictranscoder.model.ListPipelinesRequest.ReadOnly =
    zio.aws.elastictranscoder.model.ListPipelinesRequest.wrap(buildAwsValue())
}
object ListPipelinesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.ListPipelinesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.ListPipelinesRequest =
      zio.aws.elastictranscoder.model.ListPipelinesRequest(
        ascending.map(value => value),
        pageToken.map(value => value)
      )
    def ascending: Optional[Ascending]
    def pageToken: Optional[Id]
    def getAscending: ZIO[Any, AwsError, Ascending] =
      AwsError.unwrapOptionField("ascending", ascending)
    def getPageToken: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("pageToken", pageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.ListPipelinesRequest
  ) extends zio.aws.elastictranscoder.model.ListPipelinesRequest.ReadOnly {
    override val ascending: Optional[Ascending] = zio.aws.core.internal
      .optionalFromNullable(impl.ascending())
      .map(value => zio.aws.elastictranscoder.model.primitives.Ascending(value))
    override val pageToken: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.pageToken())
      .map(value => zio.aws.elastictranscoder.model.primitives.Id(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.ListPipelinesRequest
  ): zio.aws.elastictranscoder.model.ListPipelinesRequest.ReadOnly =
    new Wrapper(impl)
}
