package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elastictranscoder.model.primitives.{
  Key,
  Filename,
  JobStatus,
  Description,
  PlaylistFormat
}
import scala.jdk.CollectionConverters.*
final case class Playlist(
    name: Optional[Filename] = Optional.Absent,
    format: Optional[PlaylistFormat] = Optional.Absent,
    outputKeys: Optional[Iterable[Key]] = Optional.Absent,
    hlsContentProtection: Optional[
      zio.aws.elastictranscoder.model.HlsContentProtection
    ] = Optional.Absent,
    playReadyDrm: Optional[zio.aws.elastictranscoder.model.PlayReadyDrm] =
      Optional.Absent,
    status: Optional[JobStatus] = Optional.Absent,
    statusDetail: Optional[Description] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.Playlist = {
    import Playlist.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.Playlist
      .builder()
      .optionallyWith(
        name.map(value => Filename.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        format.map(value => PlaylistFormat.unwrap(value): java.lang.String)
      )(_.format)
      .optionallyWith(
        outputKeys.map(value =>
          value.map { item =>
            Key.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.outputKeys)
      .optionallyWith(hlsContentProtection.map(value => value.buildAwsValue()))(
        _.hlsContentProtection
      )
      .optionallyWith(playReadyDrm.map(value => value.buildAwsValue()))(
        _.playReadyDrm
      )
      .optionallyWith(
        status.map(value => JobStatus.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        statusDetail.map(value => Description.unwrap(value): java.lang.String)
      )(_.statusDetail)
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.Playlist.ReadOnly =
    zio.aws.elastictranscoder.model.Playlist.wrap(buildAwsValue())
}
object Playlist {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.Playlist
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.Playlist =
      zio.aws.elastictranscoder.model.Playlist(
        name.map(value => value),
        format.map(value => value),
        outputKeys.map(value => value),
        hlsContentProtection.map(value => value.asEditable),
        playReadyDrm.map(value => value.asEditable),
        status.map(value => value),
        statusDetail.map(value => value)
      )
    def name: Optional[Filename]
    def format: Optional[PlaylistFormat]
    def outputKeys: Optional[List[Key]]
    def hlsContentProtection: Optional[
      zio.aws.elastictranscoder.model.HlsContentProtection.ReadOnly
    ]
    def playReadyDrm
        : Optional[zio.aws.elastictranscoder.model.PlayReadyDrm.ReadOnly]
    def status: Optional[JobStatus]
    def statusDetail: Optional[Description]
    def getName: ZIO[Any, AwsError, Filename] =
      AwsError.unwrapOptionField("name", name)
    def getFormat: ZIO[Any, AwsError, PlaylistFormat] =
      AwsError.unwrapOptionField("format", format)
    def getOutputKeys: ZIO[Any, AwsError, List[Key]] =
      AwsError.unwrapOptionField("outputKeys", outputKeys)
    def getHlsContentProtection: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.HlsContentProtection.ReadOnly
    ] = AwsError.unwrapOptionField("hlsContentProtection", hlsContentProtection)
    def getPlayReadyDrm: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.PlayReadyDrm.ReadOnly
    ] = AwsError.unwrapOptionField("playReadyDrm", playReadyDrm)
    def getStatus: ZIO[Any, AwsError, JobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusDetail: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("statusDetail", statusDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.Playlist
  ) extends zio.aws.elastictranscoder.model.Playlist.ReadOnly {
    override val name: Optional[Filename] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.elastictranscoder.model.primitives.Filename(value))
    override val format: Optional[PlaylistFormat] = zio.aws.core.internal
      .optionalFromNullable(impl.format())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.PlaylistFormat(value)
      )
    override val outputKeys: Optional[List[Key]] = zio.aws.core.internal
      .optionalFromNullable(impl.outputKeys())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elastictranscoder.model.primitives.Key(item)
        }.toList
      )
    override val hlsContentProtection: Optional[
      zio.aws.elastictranscoder.model.HlsContentProtection.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.hlsContentProtection())
      .map(value =>
        zio.aws.elastictranscoder.model.HlsContentProtection.wrap(value)
      )
    override val playReadyDrm
        : Optional[zio.aws.elastictranscoder.model.PlayReadyDrm.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.playReadyDrm())
        .map(value => zio.aws.elastictranscoder.model.PlayReadyDrm.wrap(value))
    override val status: Optional[JobStatus] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.elastictranscoder.model.primitives.JobStatus(value))
    override val statusDetail: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.statusDetail())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.Description(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.Playlist
  ): zio.aws.elastictranscoder.model.Playlist.ReadOnly = new Wrapper(impl)
}
