package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elastictranscoder.model.primitives.{
  Key,
  PlaylistFormat,
  Filename
}
import scala.jdk.CollectionConverters.*
final case class CreateJobPlaylist(
    name: Optional[Filename] = Optional.Absent,
    format: Optional[PlaylistFormat] = Optional.Absent,
    outputKeys: Optional[Iterable[Key]] = Optional.Absent,
    hlsContentProtection: Optional[
      zio.aws.elastictranscoder.model.HlsContentProtection
    ] = Optional.Absent,
    playReadyDrm: Optional[zio.aws.elastictranscoder.model.PlayReadyDrm] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.CreateJobPlaylist = {
    import CreateJobPlaylist.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.CreateJobPlaylist
      .builder()
      .optionallyWith(
        name.map(value => Filename.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        format.map(value => PlaylistFormat.unwrap(value): java.lang.String)
      )(_.format)
      .optionallyWith(
        outputKeys.map(value =>
          value.map { item =>
            Key.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.outputKeys)
      .optionallyWith(hlsContentProtection.map(value => value.buildAwsValue()))(
        _.hlsContentProtection
      )
      .optionallyWith(playReadyDrm.map(value => value.buildAwsValue()))(
        _.playReadyDrm
      )
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.CreateJobPlaylist.ReadOnly =
    zio.aws.elastictranscoder.model.CreateJobPlaylist.wrap(buildAwsValue())
}
object CreateJobPlaylist {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.CreateJobPlaylist
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.CreateJobPlaylist =
      zio.aws.elastictranscoder.model.CreateJobPlaylist(
        name.map(value => value),
        format.map(value => value),
        outputKeys.map(value => value),
        hlsContentProtection.map(value => value.asEditable),
        playReadyDrm.map(value => value.asEditable)
      )
    def name: Optional[Filename]
    def format: Optional[PlaylistFormat]
    def outputKeys: Optional[List[Key]]
    def hlsContentProtection: Optional[
      zio.aws.elastictranscoder.model.HlsContentProtection.ReadOnly
    ]
    def playReadyDrm
        : Optional[zio.aws.elastictranscoder.model.PlayReadyDrm.ReadOnly]
    def getName: ZIO[Any, AwsError, Filename] =
      AwsError.unwrapOptionField("name", name)
    def getFormat: ZIO[Any, AwsError, PlaylistFormat] =
      AwsError.unwrapOptionField("format", format)
    def getOutputKeys: ZIO[Any, AwsError, List[Key]] =
      AwsError.unwrapOptionField("outputKeys", outputKeys)
    def getHlsContentProtection: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.HlsContentProtection.ReadOnly
    ] = AwsError.unwrapOptionField("hlsContentProtection", hlsContentProtection)
    def getPlayReadyDrm: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.PlayReadyDrm.ReadOnly
    ] = AwsError.unwrapOptionField("playReadyDrm", playReadyDrm)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.CreateJobPlaylist
  ) extends zio.aws.elastictranscoder.model.CreateJobPlaylist.ReadOnly {
    override val name: Optional[Filename] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.elastictranscoder.model.primitives.Filename(value))
    override val format: Optional[PlaylistFormat] = zio.aws.core.internal
      .optionalFromNullable(impl.format())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.PlaylistFormat(value)
      )
    override val outputKeys: Optional[List[Key]] = zio.aws.core.internal
      .optionalFromNullable(impl.outputKeys())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elastictranscoder.model.primitives.Key(item)
        }.toList
      )
    override val hlsContentProtection: Optional[
      zio.aws.elastictranscoder.model.HlsContentProtection.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.hlsContentProtection())
      .map(value =>
        zio.aws.elastictranscoder.model.HlsContentProtection.wrap(value)
      )
    override val playReadyDrm
        : Optional[zio.aws.elastictranscoder.model.PlayReadyDrm.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.playReadyDrm())
        .map(value => zio.aws.elastictranscoder.model.PlayReadyDrm.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.CreateJobPlaylist
  ): zio.aws.elastictranscoder.model.CreateJobPlaylist.ReadOnly = new Wrapper(
    impl
  )
}
