package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elastictranscoder.model.primitives.{
  AudioPackingMode,
  AudioBitRate,
  AudioChannels,
  AudioSampleRate,
  AudioCodec
}
import scala.jdk.CollectionConverters.*
final case class AudioParameters(
    codec: Optional[AudioCodec] = Optional.Absent,
    sampleRate: Optional[AudioSampleRate] = Optional.Absent,
    bitRate: Optional[AudioBitRate] = Optional.Absent,
    channels: Optional[AudioChannels] = Optional.Absent,
    audioPackingMode: Optional[AudioPackingMode] = Optional.Absent,
    codecOptions: Optional[zio.aws.elastictranscoder.model.AudioCodecOptions] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.AudioParameters = {
    import AudioParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.AudioParameters
      .builder()
      .optionallyWith(
        codec.map(value => AudioCodec.unwrap(value): java.lang.String)
      )(_.codec)
      .optionallyWith(
        sampleRate.map(value => AudioSampleRate.unwrap(value): java.lang.String)
      )(_.sampleRate)
      .optionallyWith(
        bitRate.map(value => AudioBitRate.unwrap(value): java.lang.String)
      )(_.bitRate)
      .optionallyWith(
        channels.map(value => AudioChannels.unwrap(value): java.lang.String)
      )(_.channels)
      .optionallyWith(
        audioPackingMode.map(value =>
          AudioPackingMode.unwrap(value): java.lang.String
        )
      )(_.audioPackingMode)
      .optionallyWith(codecOptions.map(value => value.buildAwsValue()))(
        _.codecOptions
      )
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.AudioParameters.ReadOnly =
    zio.aws.elastictranscoder.model.AudioParameters.wrap(buildAwsValue())
}
object AudioParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.AudioParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.AudioParameters =
      zio.aws.elastictranscoder.model.AudioParameters(
        codec.map(value => value),
        sampleRate.map(value => value),
        bitRate.map(value => value),
        channels.map(value => value),
        audioPackingMode.map(value => value),
        codecOptions.map(value => value.asEditable)
      )
    def codec: Optional[AudioCodec]
    def sampleRate: Optional[AudioSampleRate]
    def bitRate: Optional[AudioBitRate]
    def channels: Optional[AudioChannels]
    def audioPackingMode: Optional[AudioPackingMode]
    def codecOptions
        : Optional[zio.aws.elastictranscoder.model.AudioCodecOptions.ReadOnly]
    def getCodec: ZIO[Any, AwsError, AudioCodec] =
      AwsError.unwrapOptionField("codec", codec)
    def getSampleRate: ZIO[Any, AwsError, AudioSampleRate] =
      AwsError.unwrapOptionField("sampleRate", sampleRate)
    def getBitRate: ZIO[Any, AwsError, AudioBitRate] =
      AwsError.unwrapOptionField("bitRate", bitRate)
    def getChannels: ZIO[Any, AwsError, AudioChannels] =
      AwsError.unwrapOptionField("channels", channels)
    def getAudioPackingMode: ZIO[Any, AwsError, AudioPackingMode] =
      AwsError.unwrapOptionField("audioPackingMode", audioPackingMode)
    def getCodecOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.AudioCodecOptions.ReadOnly
    ] = AwsError.unwrapOptionField("codecOptions", codecOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.AudioParameters
  ) extends zio.aws.elastictranscoder.model.AudioParameters.ReadOnly {
    override val codec: Optional[AudioCodec] = zio.aws.core.internal
      .optionalFromNullable(impl.codec())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.AudioCodec(value)
      )
    override val sampleRate: Optional[AudioSampleRate] = zio.aws.core.internal
      .optionalFromNullable(impl.sampleRate())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.AudioSampleRate(value)
      )
    override val bitRate: Optional[AudioBitRate] = zio.aws.core.internal
      .optionalFromNullable(impl.bitRate())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.AudioBitRate(value)
      )
    override val channels: Optional[AudioChannels] = zio.aws.core.internal
      .optionalFromNullable(impl.channels())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.AudioChannels(value)
      )
    override val audioPackingMode: Optional[AudioPackingMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.audioPackingMode())
        .map(value =>
          zio.aws.elastictranscoder.model.primitives.AudioPackingMode(value)
        )
    override val codecOptions
        : Optional[zio.aws.elastictranscoder.model.AudioCodecOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.codecOptions())
        .map(value =>
          zio.aws.elastictranscoder.model.AudioCodecOptions.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.AudioParameters
  ): zio.aws.elastictranscoder.model.AudioParameters.ReadOnly = new Wrapper(
    impl
  )
}
