package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elastictranscoder.model.primitives.{
  KeyIdGuid,
  PlayReadyDrmFormatString,
  NonEmptyBase64EncodedString,
  ZeroTo255String,
  OneTo512String
}
import scala.jdk.CollectionConverters.*
final case class PlayReadyDrm(
    format: Optional[PlayReadyDrmFormatString] = Optional.Absent,
    key: Optional[NonEmptyBase64EncodedString] = Optional.Absent,
    keyMd5: Optional[NonEmptyBase64EncodedString] = Optional.Absent,
    keyId: Optional[KeyIdGuid] = Optional.Absent,
    initializationVector: Optional[ZeroTo255String] = Optional.Absent,
    licenseAcquisitionUrl: Optional[OneTo512String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.PlayReadyDrm = {
    import PlayReadyDrm.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.PlayReadyDrm
      .builder()
      .optionallyWith(
        format.map(value =>
          PlayReadyDrmFormatString.unwrap(value): java.lang.String
        )
      )(_.format)
      .optionallyWith(
        key.map(value =>
          NonEmptyBase64EncodedString.unwrap(value): java.lang.String
        )
      )(_.key)
      .optionallyWith(
        keyMd5.map(value =>
          NonEmptyBase64EncodedString.unwrap(value): java.lang.String
        )
      )(_.keyMd5)
      .optionallyWith(
        keyId.map(value => KeyIdGuid.unwrap(value): java.lang.String)
      )(_.keyId)
      .optionallyWith(
        initializationVector.map(value =>
          ZeroTo255String.unwrap(value): java.lang.String
        )
      )(_.initializationVector)
      .optionallyWith(
        licenseAcquisitionUrl.map(value =>
          OneTo512String.unwrap(value): java.lang.String
        )
      )(_.licenseAcquisitionUrl)
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.PlayReadyDrm.ReadOnly =
    zio.aws.elastictranscoder.model.PlayReadyDrm.wrap(buildAwsValue())
}
object PlayReadyDrm {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.PlayReadyDrm
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.PlayReadyDrm =
      zio.aws.elastictranscoder.model.PlayReadyDrm(
        format.map(value => value),
        key.map(value => value),
        keyMd5.map(value => value),
        keyId.map(value => value),
        initializationVector.map(value => value),
        licenseAcquisitionUrl.map(value => value)
      )
    def format: Optional[PlayReadyDrmFormatString]
    def key: Optional[NonEmptyBase64EncodedString]
    def keyMd5: Optional[NonEmptyBase64EncodedString]
    def keyId: Optional[KeyIdGuid]
    def initializationVector: Optional[ZeroTo255String]
    def licenseAcquisitionUrl: Optional[OneTo512String]
    def getFormat: ZIO[Any, AwsError, PlayReadyDrmFormatString] =
      AwsError.unwrapOptionField("format", format)
    def getKey: ZIO[Any, AwsError, NonEmptyBase64EncodedString] =
      AwsError.unwrapOptionField("key", key)
    def getKeyMd5: ZIO[Any, AwsError, NonEmptyBase64EncodedString] =
      AwsError.unwrapOptionField("keyMd5", keyMd5)
    def getKeyId: ZIO[Any, AwsError, KeyIdGuid] =
      AwsError.unwrapOptionField("keyId", keyId)
    def getInitializationVector: ZIO[Any, AwsError, ZeroTo255String] =
      AwsError.unwrapOptionField("initializationVector", initializationVector)
    def getLicenseAcquisitionUrl: ZIO[Any, AwsError, OneTo512String] =
      AwsError.unwrapOptionField("licenseAcquisitionUrl", licenseAcquisitionUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.PlayReadyDrm
  ) extends zio.aws.elastictranscoder.model.PlayReadyDrm.ReadOnly {
    override val format: Optional[PlayReadyDrmFormatString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.format())
        .map(value =>
          zio.aws.elastictranscoder.model.primitives
            .PlayReadyDrmFormatString(value)
        )
    override val key: Optional[NonEmptyBase64EncodedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.key())
        .map(value =>
          zio.aws.elastictranscoder.model.primitives
            .NonEmptyBase64EncodedString(value)
        )
    override val keyMd5: Optional[NonEmptyBase64EncodedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyMd5())
        .map(value =>
          zio.aws.elastictranscoder.model.primitives
            .NonEmptyBase64EncodedString(value)
        )
    override val keyId: Optional[KeyIdGuid] = zio.aws.core.internal
      .optionalFromNullable(impl.keyId())
      .map(value => zio.aws.elastictranscoder.model.primitives.KeyIdGuid(value))
    override val initializationVector: Optional[ZeroTo255String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.initializationVector())
        .map(value =>
          zio.aws.elastictranscoder.model.primitives.ZeroTo255String(value)
        )
    override val licenseAcquisitionUrl: Optional[OneTo512String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.licenseAcquisitionUrl())
        .map(value =>
          zio.aws.elastictranscoder.model.primitives.OneTo512String(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.PlayReadyDrm
  ): zio.aws.elastictranscoder.model.PlayReadyDrm.ReadOnly = new Wrapper(impl)
}
