package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elastictranscoder.model.primitives.{
  FrameRate,
  JobContainer,
  AspectRatio,
  LongKey,
  Interlaced,
  Resolution
}
import scala.jdk.CollectionConverters.*
final case class JobInput(
    key: Optional[LongKey] = Optional.Absent,
    frameRate: Optional[FrameRate] = Optional.Absent,
    resolution: Optional[Resolution] = Optional.Absent,
    aspectRatio: Optional[AspectRatio] = Optional.Absent,
    interlaced: Optional[Interlaced] = Optional.Absent,
    container: Optional[JobContainer] = Optional.Absent,
    encryption: Optional[zio.aws.elastictranscoder.model.Encryption] =
      Optional.Absent,
    timeSpan: Optional[zio.aws.elastictranscoder.model.TimeSpan] =
      Optional.Absent,
    inputCaptions: Optional[zio.aws.elastictranscoder.model.InputCaptions] =
      Optional.Absent,
    detectedProperties: Optional[
      zio.aws.elastictranscoder.model.DetectedProperties
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.JobInput = {
    import JobInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.JobInput
      .builder()
      .optionallyWith(
        key.map(value => LongKey.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        frameRate.map(value => FrameRate.unwrap(value): java.lang.String)
      )(_.frameRate)
      .optionallyWith(
        resolution.map(value => Resolution.unwrap(value): java.lang.String)
      )(_.resolution)
      .optionallyWith(
        aspectRatio.map(value => AspectRatio.unwrap(value): java.lang.String)
      )(_.aspectRatio)
      .optionallyWith(
        interlaced.map(value => Interlaced.unwrap(value): java.lang.String)
      )(_.interlaced)
      .optionallyWith(
        container.map(value => JobContainer.unwrap(value): java.lang.String)
      )(_.container)
      .optionallyWith(encryption.map(value => value.buildAwsValue()))(
        _.encryption
      )
      .optionallyWith(timeSpan.map(value => value.buildAwsValue()))(_.timeSpan)
      .optionallyWith(inputCaptions.map(value => value.buildAwsValue()))(
        _.inputCaptions
      )
      .optionallyWith(detectedProperties.map(value => value.buildAwsValue()))(
        _.detectedProperties
      )
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.JobInput.ReadOnly =
    zio.aws.elastictranscoder.model.JobInput.wrap(buildAwsValue())
}
object JobInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.JobInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.JobInput =
      zio.aws.elastictranscoder.model.JobInput(
        key.map(value => value),
        frameRate.map(value => value),
        resolution.map(value => value),
        aspectRatio.map(value => value),
        interlaced.map(value => value),
        container.map(value => value),
        encryption.map(value => value.asEditable),
        timeSpan.map(value => value.asEditable),
        inputCaptions.map(value => value.asEditable),
        detectedProperties.map(value => value.asEditable)
      )
    def key: Optional[LongKey]
    def frameRate: Optional[FrameRate]
    def resolution: Optional[Resolution]
    def aspectRatio: Optional[AspectRatio]
    def interlaced: Optional[Interlaced]
    def container: Optional[JobContainer]
    def encryption
        : Optional[zio.aws.elastictranscoder.model.Encryption.ReadOnly]
    def timeSpan: Optional[zio.aws.elastictranscoder.model.TimeSpan.ReadOnly]
    def inputCaptions
        : Optional[zio.aws.elastictranscoder.model.InputCaptions.ReadOnly]
    def detectedProperties
        : Optional[zio.aws.elastictranscoder.model.DetectedProperties.ReadOnly]
    def getKey: ZIO[Any, AwsError, LongKey] =
      AwsError.unwrapOptionField("key", key)
    def getFrameRate: ZIO[Any, AwsError, FrameRate] =
      AwsError.unwrapOptionField("frameRate", frameRate)
    def getResolution: ZIO[Any, AwsError, Resolution] =
      AwsError.unwrapOptionField("resolution", resolution)
    def getAspectRatio: ZIO[Any, AwsError, AspectRatio] =
      AwsError.unwrapOptionField("aspectRatio", aspectRatio)
    def getInterlaced: ZIO[Any, AwsError, Interlaced] =
      AwsError.unwrapOptionField("interlaced", interlaced)
    def getContainer: ZIO[Any, AwsError, JobContainer] =
      AwsError.unwrapOptionField("container", container)
    def getEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.Encryption.ReadOnly
    ] = AwsError.unwrapOptionField("encryption", encryption)
    def getTimeSpan: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.TimeSpan.ReadOnly
    ] = AwsError.unwrapOptionField("timeSpan", timeSpan)
    def getInputCaptions: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.InputCaptions.ReadOnly
    ] = AwsError.unwrapOptionField("inputCaptions", inputCaptions)
    def getDetectedProperties: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.DetectedProperties.ReadOnly
    ] = AwsError.unwrapOptionField("detectedProperties", detectedProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.JobInput
  ) extends zio.aws.elastictranscoder.model.JobInput.ReadOnly {
    override val key: Optional[LongKey] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.elastictranscoder.model.primitives.LongKey(value))
    override val frameRate: Optional[FrameRate] = zio.aws.core.internal
      .optionalFromNullable(impl.frameRate())
      .map(value => zio.aws.elastictranscoder.model.primitives.FrameRate(value))
    override val resolution: Optional[Resolution] = zio.aws.core.internal
      .optionalFromNullable(impl.resolution())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.Resolution(value)
      )
    override val aspectRatio: Optional[AspectRatio] = zio.aws.core.internal
      .optionalFromNullable(impl.aspectRatio())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.AspectRatio(value)
      )
    override val interlaced: Optional[Interlaced] = zio.aws.core.internal
      .optionalFromNullable(impl.interlaced())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.Interlaced(value)
      )
    override val container: Optional[JobContainer] = zio.aws.core.internal
      .optionalFromNullable(impl.container())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.JobContainer(value)
      )
    override val encryption
        : Optional[zio.aws.elastictranscoder.model.Encryption.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryption())
        .map(value => zio.aws.elastictranscoder.model.Encryption.wrap(value))
    override val timeSpan
        : Optional[zio.aws.elastictranscoder.model.TimeSpan.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeSpan())
        .map(value => zio.aws.elastictranscoder.model.TimeSpan.wrap(value))
    override val inputCaptions
        : Optional[zio.aws.elastictranscoder.model.InputCaptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputCaptions())
        .map(value => zio.aws.elastictranscoder.model.InputCaptions.wrap(value))
    override val detectedProperties: Optional[
      zio.aws.elastictranscoder.model.DetectedProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.detectedProperties())
      .map(value =>
        zio.aws.elastictranscoder.model.DetectedProperties.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.JobInput
  ): zio.aws.elastictranscoder.model.JobInput.ReadOnly = new Wrapper(impl)
}
