package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.elastictranscoder.model.primitives.{PipelineStatus, Id}
import scala.jdk.CollectionConverters.*
final case class UpdatePipelineStatusRequest(id: Id, status: PipelineStatus) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineStatusRequest = {
    import UpdatePipelineStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineStatusRequest
      .builder()
      .id(Id.unwrap(id): java.lang.String)
      .status(PipelineStatus.unwrap(status): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.elastictranscoder.model.UpdatePipelineStatusRequest.ReadOnly =
    zio.aws.elastictranscoder.model.UpdatePipelineStatusRequest
      .wrap(buildAwsValue())
}
object UpdatePipelineStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elastictranscoder.model.UpdatePipelineStatusRequest =
      zio.aws.elastictranscoder.model.UpdatePipelineStatusRequest(id, status)
    def id: Id
    def status: PipelineStatus
    def getId: ZIO[Any, Nothing, Id] = ZIO.succeed(id)
    def getStatus: ZIO[Any, Nothing, PipelineStatus] = ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineStatusRequest
  ) extends zio.aws.elastictranscoder.model.UpdatePipelineStatusRequest.ReadOnly {
    override val id: Id =
      zio.aws.elastictranscoder.model.primitives.Id(impl.id())
    override val status: PipelineStatus =
      zio.aws.elastictranscoder.model.primitives.PipelineStatus(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineStatusRequest
  ): zio.aws.elastictranscoder.model.UpdatePipelineStatusRequest.ReadOnly =
    new Wrapper(impl)
}
