package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elastictranscoder.model.primitives.{
  Name,
  TimeOffset,
  Key,
  LongKey
}
import scala.jdk.CollectionConverters.*
final case class CaptionSource(
    key: Optional[LongKey] = Optional.Absent,
    language: Optional[Key] = Optional.Absent,
    timeOffset: Optional[TimeOffset] = Optional.Absent,
    label: Optional[Name] = Optional.Absent,
    encryption: Optional[zio.aws.elastictranscoder.model.Encryption] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.CaptionSource = {
    import CaptionSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.CaptionSource
      .builder()
      .optionallyWith(
        key.map(value => LongKey.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        language.map(value => Key.unwrap(value): java.lang.String)
      )(_.language)
      .optionallyWith(
        timeOffset.map(value => TimeOffset.unwrap(value): java.lang.String)
      )(_.timeOffset)
      .optionallyWith(label.map(value => Name.unwrap(value): java.lang.String))(
        _.label
      )
      .optionallyWith(encryption.map(value => value.buildAwsValue()))(
        _.encryption
      )
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.CaptionSource.ReadOnly =
    zio.aws.elastictranscoder.model.CaptionSource.wrap(buildAwsValue())
}
object CaptionSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.CaptionSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.CaptionSource =
      zio.aws.elastictranscoder.model.CaptionSource(
        key.map(value => value),
        language.map(value => value),
        timeOffset.map(value => value),
        label.map(value => value),
        encryption.map(value => value.asEditable)
      )
    def key: Optional[LongKey]
    def language: Optional[Key]
    def timeOffset: Optional[TimeOffset]
    def label: Optional[Name]
    def encryption
        : Optional[zio.aws.elastictranscoder.model.Encryption.ReadOnly]
    def getKey: ZIO[Any, AwsError, LongKey] =
      AwsError.unwrapOptionField("key", key)
    def getLanguage: ZIO[Any, AwsError, Key] =
      AwsError.unwrapOptionField("language", language)
    def getTimeOffset: ZIO[Any, AwsError, TimeOffset] =
      AwsError.unwrapOptionField("timeOffset", timeOffset)
    def getLabel: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("label", label)
    def getEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.Encryption.ReadOnly
    ] = AwsError.unwrapOptionField("encryption", encryption)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.CaptionSource
  ) extends zio.aws.elastictranscoder.model.CaptionSource.ReadOnly {
    override val key: Optional[LongKey] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.elastictranscoder.model.primitives.LongKey(value))
    override val language: Optional[Key] = zio.aws.core.internal
      .optionalFromNullable(impl.language())
      .map(value => zio.aws.elastictranscoder.model.primitives.Key(value))
    override val timeOffset: Optional[TimeOffset] = zio.aws.core.internal
      .optionalFromNullable(impl.timeOffset())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.TimeOffset(value)
      )
    override val label: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.label())
      .map(value => zio.aws.elastictranscoder.model.primitives.Name(value))
    override val encryption
        : Optional[zio.aws.elastictranscoder.model.Encryption.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryption())
        .map(value => zio.aws.elastictranscoder.model.Encryption.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.CaptionSource
  ): zio.aws.elastictranscoder.model.CaptionSource.ReadOnly = new Wrapper(impl)
}
