package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elastictranscoder.model.primitives.CaptionMergePolicy
import scala.jdk.CollectionConverters.*
final case class Captions(
    mergePolicy: Option[CaptionMergePolicy] = None,
    captionSources: Option[
      Iterable[zio.aws.elastictranscoder.model.CaptionSource]
    ] = None,
    captionFormats: Option[
      Iterable[zio.aws.elastictranscoder.model.CaptionFormat]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.Captions = {
    import Captions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.Captions
      .builder()
      .optionallyWith(
        mergePolicy.map(value =>
          CaptionMergePolicy.unwrap(value): java.lang.String
        )
      )(_.mergePolicy)
      .optionallyWith(
        captionSources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.captionSources)
      .optionallyWith(
        captionFormats.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.captionFormats)
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.Captions.ReadOnly =
    zio.aws.elastictranscoder.model.Captions.wrap(buildAwsValue())
}
object Captions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.Captions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.Captions =
      zio.aws.elastictranscoder.model.Captions(
        mergePolicy.map(value => value),
        captionSources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        captionFormats.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def mergePolicy: Option[CaptionMergePolicy]
    def captionSources
        : Option[List[zio.aws.elastictranscoder.model.CaptionSource.ReadOnly]]
    def captionFormats
        : Option[List[zio.aws.elastictranscoder.model.CaptionFormat.ReadOnly]]
    def getMergePolicy: ZIO[Any, AwsError, CaptionMergePolicy] =
      AwsError.unwrapOptionField("mergePolicy", mergePolicy)
    def getCaptionSources: ZIO[Any, AwsError, List[
      zio.aws.elastictranscoder.model.CaptionSource.ReadOnly
    ]] = AwsError.unwrapOptionField("captionSources", captionSources)
    def getCaptionFormats: ZIO[Any, AwsError, List[
      zio.aws.elastictranscoder.model.CaptionFormat.ReadOnly
    ]] = AwsError.unwrapOptionField("captionFormats", captionFormats)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.Captions
  ) extends zio.aws.elastictranscoder.model.Captions.ReadOnly {
    override val mergePolicy: Option[CaptionMergePolicy] = scala
      .Option(impl.mergePolicy())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.CaptionMergePolicy(value)
      )
    override val captionSources
        : Option[List[zio.aws.elastictranscoder.model.CaptionSource.ReadOnly]] =
      scala
        .Option(impl.captionSources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elastictranscoder.model.CaptionSource.wrap(item)
          }.toList
        )
    override val captionFormats
        : Option[List[zio.aws.elastictranscoder.model.CaptionFormat.ReadOnly]] =
      scala
        .Option(impl.captionFormats())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elastictranscoder.model.CaptionFormat.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.Captions
  ): zio.aws.elastictranscoder.model.Captions.ReadOnly = new Wrapper(impl)
}
