package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elastictranscoder.model.primitives.{
  WatermarkKey,
  PresetWatermarkId
}
import scala.jdk.CollectionConverters.*
final case class JobWatermark(
    presetWatermarkId: Option[PresetWatermarkId] = None,
    inputKey: Option[WatermarkKey] = None,
    encryption: Option[zio.aws.elastictranscoder.model.Encryption] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.JobWatermark = {
    import JobWatermark.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.JobWatermark
      .builder()
      .optionallyWith(
        presetWatermarkId.map(value =>
          PresetWatermarkId.unwrap(value): java.lang.String
        )
      )(_.presetWatermarkId)
      .optionallyWith(
        inputKey.map(value => WatermarkKey.unwrap(value): java.lang.String)
      )(_.inputKey)
      .optionallyWith(encryption.map(value => value.buildAwsValue()))(
        _.encryption
      )
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.JobWatermark.ReadOnly =
    zio.aws.elastictranscoder.model.JobWatermark.wrap(buildAwsValue())
}
object JobWatermark {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.JobWatermark
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.JobWatermark =
      zio.aws.elastictranscoder.model.JobWatermark(
        presetWatermarkId.map(value => value),
        inputKey.map(value => value),
        encryption.map(value => value.asEditable)
      )
    def presetWatermarkId: Option[PresetWatermarkId]
    def inputKey: Option[WatermarkKey]
    def encryption: Option[zio.aws.elastictranscoder.model.Encryption.ReadOnly]
    def getPresetWatermarkId: ZIO[Any, AwsError, PresetWatermarkId] =
      AwsError.unwrapOptionField("presetWatermarkId", presetWatermarkId)
    def getInputKey: ZIO[Any, AwsError, WatermarkKey] =
      AwsError.unwrapOptionField("inputKey", inputKey)
    def getEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.Encryption.ReadOnly
    ] = AwsError.unwrapOptionField("encryption", encryption)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.JobWatermark
  ) extends zio.aws.elastictranscoder.model.JobWatermark.ReadOnly {
    override val presetWatermarkId: Option[PresetWatermarkId] = scala
      .Option(impl.presetWatermarkId())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.PresetWatermarkId(value)
      )
    override val inputKey: Option[WatermarkKey] = scala
      .Option(impl.inputKey())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.WatermarkKey(value)
      )
    override val encryption
        : Option[zio.aws.elastictranscoder.model.Encryption.ReadOnly] = scala
      .Option(impl.encryption())
      .map(value => zio.aws.elastictranscoder.model.Encryption.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.JobWatermark
  ): zio.aws.elastictranscoder.model.JobWatermark.ReadOnly = new Wrapper(impl)
}
