package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elastictranscoder.model.primitives.{Ascending, Id}
import scala.jdk.CollectionConverters.*
final case class ListJobsByPipelineRequest(
    pipelineId: Id,
    ascending: Option[Ascending] = None,
    pageToken: Option[Id] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.ListJobsByPipelineRequest = {
    import ListJobsByPipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.ListJobsByPipelineRequest
      .builder()
      .pipelineId(Id.unwrap(pipelineId): java.lang.String)
      .optionallyWith(
        ascending.map(value => Ascending.unwrap(value): java.lang.String)
      )(_.ascending)
      .optionallyWith(
        pageToken.map(value => Id.unwrap(value): java.lang.String)
      )(_.pageToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elastictranscoder.model.ListJobsByPipelineRequest.ReadOnly =
    zio.aws.elastictranscoder.model.ListJobsByPipelineRequest
      .wrap(buildAwsValue())
}
object ListJobsByPipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.ListJobsByPipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.ListJobsByPipelineRequest =
      zio.aws.elastictranscoder.model.ListJobsByPipelineRequest(
        pipelineId,
        ascending.map(value => value),
        pageToken.map(value => value)
      )
    def pipelineId: Id
    def ascending: Option[Ascending]
    def pageToken: Option[Id]
    def getPipelineId: ZIO[Any, Nothing, Id] = ZIO.succeed(pipelineId)
    def getAscending: ZIO[Any, AwsError, Ascending] =
      AwsError.unwrapOptionField("ascending", ascending)
    def getPageToken: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("pageToken", pageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.ListJobsByPipelineRequest
  ) extends zio.aws.elastictranscoder.model.ListJobsByPipelineRequest.ReadOnly {
    override val pipelineId: Id =
      zio.aws.elastictranscoder.model.primitives.Id(impl.pipelineId())
    override val ascending: Option[Ascending] = scala
      .Option(impl.ascending())
      .map(value => zio.aws.elastictranscoder.model.primitives.Ascending(value))
    override val pageToken: Option[Id] = scala
      .Option(impl.pageToken())
      .map(value => zio.aws.elastictranscoder.model.primitives.Id(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.ListJobsByPipelineRequest
  ): zio.aws.elastictranscoder.model.ListJobsByPipelineRequest.ReadOnly =
    new Wrapper(impl)
}
