package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Warning(
    code: Option[String] = None,
    message: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.Warning = {
    import Warning.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.Warning
      .builder()
      .optionallyWith(code.map(value => value: java.lang.String))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.Warning.ReadOnly =
    zio.aws.elastictranscoder.model.Warning.wrap(buildAwsValue())
}
object Warning {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.Warning
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.Warning =
      zio.aws.elastictranscoder.model
        .Warning(code.map(value => value), message.map(value => value))
    def code: Option[String]
    def message: Option[String]
    def getCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.Warning
  ) extends zio.aws.elastictranscoder.model.Warning.ReadOnly {
    override val code: Option[String] =
      scala.Option(impl.code()).map(value => value: String)
    override val message: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.Warning
  ): zio.aws.elastictranscoder.model.Warning.ReadOnly = new Wrapper(impl)
}
