package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elastictranscoder.model.primitives.{
  DigitsOrAuto,
  ThumbnailResolution,
  AspectRatio,
  JpgOrPng,
  PaddingPolicy,
  Digits,
  SizingPolicy
}
import scala.jdk.CollectionConverters.*
final case class Thumbnails(
    format: Option[JpgOrPng] = None,
    interval: Option[Digits] = None,
    resolution: Option[ThumbnailResolution] = None,
    aspectRatio: Option[AspectRatio] = None,
    maxWidth: Option[DigitsOrAuto] = None,
    maxHeight: Option[DigitsOrAuto] = None,
    sizingPolicy: Option[SizingPolicy] = None,
    paddingPolicy: Option[PaddingPolicy] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.Thumbnails = {
    import Thumbnails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.Thumbnails
      .builder()
      .optionallyWith(
        format.map(value => JpgOrPng.unwrap(value): java.lang.String)
      )(_.format)
      .optionallyWith(
        interval.map(value => Digits.unwrap(value): java.lang.String)
      )(_.interval)
      .optionallyWith(
        resolution.map(value =>
          ThumbnailResolution.unwrap(value): java.lang.String
        )
      )(_.resolution)
      .optionallyWith(
        aspectRatio.map(value => AspectRatio.unwrap(value): java.lang.String)
      )(_.aspectRatio)
      .optionallyWith(
        maxWidth.map(value => DigitsOrAuto.unwrap(value): java.lang.String)
      )(_.maxWidth)
      .optionallyWith(
        maxHeight.map(value => DigitsOrAuto.unwrap(value): java.lang.String)
      )(_.maxHeight)
      .optionallyWith(
        sizingPolicy.map(value => SizingPolicy.unwrap(value): java.lang.String)
      )(_.sizingPolicy)
      .optionallyWith(
        paddingPolicy.map(value =>
          PaddingPolicy.unwrap(value): java.lang.String
        )
      )(_.paddingPolicy)
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.Thumbnails.ReadOnly =
    zio.aws.elastictranscoder.model.Thumbnails.wrap(buildAwsValue())
}
object Thumbnails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.Thumbnails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.Thumbnails =
      zio.aws.elastictranscoder.model.Thumbnails(
        format.map(value => value),
        interval.map(value => value),
        resolution.map(value => value),
        aspectRatio.map(value => value),
        maxWidth.map(value => value),
        maxHeight.map(value => value),
        sizingPolicy.map(value => value),
        paddingPolicy.map(value => value)
      )
    def format: Option[JpgOrPng]
    def interval: Option[Digits]
    def resolution: Option[ThumbnailResolution]
    def aspectRatio: Option[AspectRatio]
    def maxWidth: Option[DigitsOrAuto]
    def maxHeight: Option[DigitsOrAuto]
    def sizingPolicy: Option[SizingPolicy]
    def paddingPolicy: Option[PaddingPolicy]
    def getFormat: ZIO[Any, AwsError, JpgOrPng] =
      AwsError.unwrapOptionField("format", format)
    def getInterval: ZIO[Any, AwsError, Digits] =
      AwsError.unwrapOptionField("interval", interval)
    def getResolution: ZIO[Any, AwsError, ThumbnailResolution] =
      AwsError.unwrapOptionField("resolution", resolution)
    def getAspectRatio: ZIO[Any, AwsError, AspectRatio] =
      AwsError.unwrapOptionField("aspectRatio", aspectRatio)
    def getMaxWidth: ZIO[Any, AwsError, DigitsOrAuto] =
      AwsError.unwrapOptionField("maxWidth", maxWidth)
    def getMaxHeight: ZIO[Any, AwsError, DigitsOrAuto] =
      AwsError.unwrapOptionField("maxHeight", maxHeight)
    def getSizingPolicy: ZIO[Any, AwsError, SizingPolicy] =
      AwsError.unwrapOptionField("sizingPolicy", sizingPolicy)
    def getPaddingPolicy: ZIO[Any, AwsError, PaddingPolicy] =
      AwsError.unwrapOptionField("paddingPolicy", paddingPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.Thumbnails
  ) extends zio.aws.elastictranscoder.model.Thumbnails.ReadOnly {
    override val format: Option[JpgOrPng] = scala
      .Option(impl.format())
      .map(value => zio.aws.elastictranscoder.model.primitives.JpgOrPng(value))
    override val interval: Option[Digits] = scala
      .Option(impl.interval())
      .map(value => zio.aws.elastictranscoder.model.primitives.Digits(value))
    override val resolution: Option[ThumbnailResolution] = scala
      .Option(impl.resolution())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.ThumbnailResolution(value)
      )
    override val aspectRatio: Option[AspectRatio] = scala
      .Option(impl.aspectRatio())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.AspectRatio(value)
      )
    override val maxWidth: Option[DigitsOrAuto] = scala
      .Option(impl.maxWidth())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.DigitsOrAuto(value)
      )
    override val maxHeight: Option[DigitsOrAuto] = scala
      .Option(impl.maxHeight())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.DigitsOrAuto(value)
      )
    override val sizingPolicy: Option[SizingPolicy] = scala
      .Option(impl.sizingPolicy())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.SizingPolicy(value)
      )
    override val paddingPolicy: Option[PaddingPolicy] = scala
      .Option(impl.paddingPolicy())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.PaddingPolicy(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.Thumbnails
  ): zio.aws.elastictranscoder.model.Thumbnails.ReadOnly = new Wrapper(impl)
}
