package zio.aws.elastictranscoder.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elastictranscoder.model.primitives.{
  Key,
  NullableLong,
  Rotate,
  JobStatus,
  Description,
  FloatString,
  ThumbnailPattern,
  NullableInteger,
  Id
}
import scala.jdk.CollectionConverters.*
final case class JobOutput(
    id: Option[String] = None,
    key: Option[Key] = None,
    thumbnailPattern: Option[ThumbnailPattern] = None,
    thumbnailEncryption: Option[zio.aws.elastictranscoder.model.Encryption] =
      None,
    rotate: Option[Rotate] = None,
    presetId: Option[Id] = None,
    segmentDuration: Option[FloatString] = None,
    status: Option[JobStatus] = None,
    statusDetail: Option[Description] = None,
    duration: Option[NullableLong] = None,
    width: Option[NullableInteger] = None,
    height: Option[NullableInteger] = None,
    frameRate: Option[FloatString] = None,
    fileSize: Option[NullableLong] = None,
    durationMillis: Option[NullableLong] = None,
    watermarks: Option[Iterable[zio.aws.elastictranscoder.model.JobWatermark]] =
      None,
    albumArt: Option[zio.aws.elastictranscoder.model.JobAlbumArt] = None,
    composition: Option[Iterable[zio.aws.elastictranscoder.model.Clip]] = None,
    captions: Option[zio.aws.elastictranscoder.model.Captions] = None,
    encryption: Option[zio.aws.elastictranscoder.model.Encryption] = None,
    appliedColorSpaceConversion: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.JobOutput = {
    import JobOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.JobOutput
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(key.map(value => Key.unwrap(value): java.lang.String))(
        _.key
      )
      .optionallyWith(
        thumbnailPattern.map(value =>
          ThumbnailPattern.unwrap(value): java.lang.String
        )
      )(_.thumbnailPattern)
      .optionallyWith(thumbnailEncryption.map(value => value.buildAwsValue()))(
        _.thumbnailEncryption
      )
      .optionallyWith(
        rotate.map(value => Rotate.unwrap(value): java.lang.String)
      )(_.rotate)
      .optionallyWith(
        presetId.map(value => Id.unwrap(value): java.lang.String)
      )(_.presetId)
      .optionallyWith(
        segmentDuration.map(value =>
          FloatString.unwrap(value): java.lang.String
        )
      )(_.segmentDuration)
      .optionallyWith(
        status.map(value => JobStatus.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        statusDetail.map(value => Description.unwrap(value): java.lang.String)
      )(_.statusDetail)
      .optionallyWith(duration.map(value => value: java.lang.Long))(_.duration)
      .optionallyWith(width.map(value => value: Integer))(_.width)
      .optionallyWith(height.map(value => value: Integer))(_.height)
      .optionallyWith(
        frameRate.map(value => FloatString.unwrap(value): java.lang.String)
      )(_.frameRate)
      .optionallyWith(fileSize.map(value => value: java.lang.Long))(_.fileSize)
      .optionallyWith(durationMillis.map(value => value: java.lang.Long))(
        _.durationMillis
      )
      .optionallyWith(
        watermarks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.watermarks)
      .optionallyWith(albumArt.map(value => value.buildAwsValue()))(_.albumArt)
      .optionallyWith(
        composition.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.composition)
      .optionallyWith(captions.map(value => value.buildAwsValue()))(_.captions)
      .optionallyWith(encryption.map(value => value.buildAwsValue()))(
        _.encryption
      )
      .optionallyWith(
        appliedColorSpaceConversion.map(value => value: java.lang.String)
      )(_.appliedColorSpaceConversion)
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.JobOutput.ReadOnly =
    zio.aws.elastictranscoder.model.JobOutput.wrap(buildAwsValue())
}
object JobOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.JobOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.JobOutput =
      zio.aws.elastictranscoder.model.JobOutput(
        id.map(value => value),
        key.map(value => value),
        thumbnailPattern.map(value => value),
        thumbnailEncryption.map(value => value.asEditable),
        rotate.map(value => value),
        presetId.map(value => value),
        segmentDuration.map(value => value),
        status.map(value => value),
        statusDetail.map(value => value),
        duration.map(value => value),
        width.map(value => value),
        height.map(value => value),
        frameRate.map(value => value),
        fileSize.map(value => value),
        durationMillis.map(value => value),
        watermarks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        albumArt.map(value => value.asEditable),
        composition.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        captions.map(value => value.asEditable),
        encryption.map(value => value.asEditable),
        appliedColorSpaceConversion.map(value => value)
      )
    def id: Option[String]
    def key: Option[Key]
    def thumbnailPattern: Option[ThumbnailPattern]
    def thumbnailEncryption
        : Option[zio.aws.elastictranscoder.model.Encryption.ReadOnly]
    def rotate: Option[Rotate]
    def presetId: Option[Id]
    def segmentDuration: Option[FloatString]
    def status: Option[JobStatus]
    def statusDetail: Option[Description]
    def duration: Option[NullableLong]
    def width: Option[NullableInteger]
    def height: Option[NullableInteger]
    def frameRate: Option[FloatString]
    def fileSize: Option[NullableLong]
    def durationMillis: Option[NullableLong]
    def watermarks
        : Option[List[zio.aws.elastictranscoder.model.JobWatermark.ReadOnly]]
    def albumArt: Option[zio.aws.elastictranscoder.model.JobAlbumArt.ReadOnly]
    def composition: Option[List[zio.aws.elastictranscoder.model.Clip.ReadOnly]]
    def captions: Option[zio.aws.elastictranscoder.model.Captions.ReadOnly]
    def encryption: Option[zio.aws.elastictranscoder.model.Encryption.ReadOnly]
    def appliedColorSpaceConversion: Option[String]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getKey: ZIO[Any, AwsError, Key] = AwsError.unwrapOptionField("key", key)
    def getThumbnailPattern: ZIO[Any, AwsError, ThumbnailPattern] =
      AwsError.unwrapOptionField("thumbnailPattern", thumbnailPattern)
    def getThumbnailEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.Encryption.ReadOnly
    ] = AwsError.unwrapOptionField("thumbnailEncryption", thumbnailEncryption)
    def getRotate: ZIO[Any, AwsError, Rotate] =
      AwsError.unwrapOptionField("rotate", rotate)
    def getPresetId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("presetId", presetId)
    def getSegmentDuration: ZIO[Any, AwsError, FloatString] =
      AwsError.unwrapOptionField("segmentDuration", segmentDuration)
    def getStatus: ZIO[Any, AwsError, JobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusDetail: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("statusDetail", statusDetail)
    def getDuration: ZIO[Any, AwsError, NullableLong] =
      AwsError.unwrapOptionField("duration", duration)
    def getWidth: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("width", width)
    def getHeight: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("height", height)
    def getFrameRate: ZIO[Any, AwsError, FloatString] =
      AwsError.unwrapOptionField("frameRate", frameRate)
    def getFileSize: ZIO[Any, AwsError, NullableLong] =
      AwsError.unwrapOptionField("fileSize", fileSize)
    def getDurationMillis: ZIO[Any, AwsError, NullableLong] =
      AwsError.unwrapOptionField("durationMillis", durationMillis)
    def getWatermarks: ZIO[Any, AwsError, List[
      zio.aws.elastictranscoder.model.JobWatermark.ReadOnly
    ]] = AwsError.unwrapOptionField("watermarks", watermarks)
    def getAlbumArt: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.JobAlbumArt.ReadOnly
    ] = AwsError.unwrapOptionField("albumArt", albumArt)
    def getComposition: ZIO[Any, AwsError, List[
      zio.aws.elastictranscoder.model.Clip.ReadOnly
    ]] = AwsError.unwrapOptionField("composition", composition)
    def getCaptions: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.Captions.ReadOnly
    ] = AwsError.unwrapOptionField("captions", captions)
    def getEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.Encryption.ReadOnly
    ] = AwsError.unwrapOptionField("encryption", encryption)
    def getAppliedColorSpaceConversion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "appliedColorSpaceConversion",
        appliedColorSpaceConversion
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.JobOutput
  ) extends zio.aws.elastictranscoder.model.JobOutput.ReadOnly {
    override val id: Option[String] =
      scala.Option(impl.id()).map(value => value: String)
    override val key: Option[Key] = scala
      .Option(impl.key())
      .map(value => zio.aws.elastictranscoder.model.primitives.Key(value))
    override val thumbnailPattern: Option[ThumbnailPattern] = scala
      .Option(impl.thumbnailPattern())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.ThumbnailPattern(value)
      )
    override val thumbnailEncryption
        : Option[zio.aws.elastictranscoder.model.Encryption.ReadOnly] = scala
      .Option(impl.thumbnailEncryption())
      .map(value => zio.aws.elastictranscoder.model.Encryption.wrap(value))
    override val rotate: Option[Rotate] = scala
      .Option(impl.rotate())
      .map(value => zio.aws.elastictranscoder.model.primitives.Rotate(value))
    override val presetId: Option[Id] = scala
      .Option(impl.presetId())
      .map(value => zio.aws.elastictranscoder.model.primitives.Id(value))
    override val segmentDuration: Option[FloatString] = scala
      .Option(impl.segmentDuration())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.FloatString(value)
      )
    override val status: Option[JobStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.elastictranscoder.model.primitives.JobStatus(value))
    override val statusDetail: Option[Description] = scala
      .Option(impl.statusDetail())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.Description(value)
      )
    override val duration: Option[NullableLong] =
      scala.Option(impl.duration()).map(value => value: NullableLong)
    override val width: Option[NullableInteger] =
      scala.Option(impl.width()).map(value => value: NullableInteger)
    override val height: Option[NullableInteger] =
      scala.Option(impl.height()).map(value => value: NullableInteger)
    override val frameRate: Option[FloatString] = scala
      .Option(impl.frameRate())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.FloatString(value)
      )
    override val fileSize: Option[NullableLong] =
      scala.Option(impl.fileSize()).map(value => value: NullableLong)
    override val durationMillis: Option[NullableLong] =
      scala.Option(impl.durationMillis()).map(value => value: NullableLong)
    override val watermarks
        : Option[List[zio.aws.elastictranscoder.model.JobWatermark.ReadOnly]] =
      scala
        .Option(impl.watermarks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elastictranscoder.model.JobWatermark.wrap(item)
          }.toList
        )
    override val albumArt
        : Option[zio.aws.elastictranscoder.model.JobAlbumArt.ReadOnly] = scala
      .Option(impl.albumArt())
      .map(value => zio.aws.elastictranscoder.model.JobAlbumArt.wrap(value))
    override val composition
        : Option[List[zio.aws.elastictranscoder.model.Clip.ReadOnly]] = scala
      .Option(impl.composition())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elastictranscoder.model.Clip.wrap(item)
        }.toList
      )
    override val captions
        : Option[zio.aws.elastictranscoder.model.Captions.ReadOnly] = scala
      .Option(impl.captions())
      .map(value => zio.aws.elastictranscoder.model.Captions.wrap(value))
    override val encryption
        : Option[zio.aws.elastictranscoder.model.Encryption.ReadOnly] = scala
      .Option(impl.encryption())
      .map(value => zio.aws.elastictranscoder.model.Encryption.wrap(value))
    override val appliedColorSpaceConversion: Option[String] = scala
      .Option(impl.appliedColorSpaceConversion())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.JobOutput
  ): zio.aws.elastictranscoder.model.JobOutput.ReadOnly = new Wrapper(impl)
}
