package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elastictranscoder.model.primitives.Id
import scala.jdk.CollectionConverters.*
final case class ListJobsByPipelineResponse(
    jobs: Option[Iterable[zio.aws.elastictranscoder.model.Job]] = None,
    nextPageToken: Option[Id] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.ListJobsByPipelineResponse = {
    import ListJobsByPipelineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.ListJobsByPipelineResponse
      .builder()
      .optionallyWith(
        jobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.jobs)
      .optionallyWith(
        nextPageToken.map(value => Id.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elastictranscoder.model.ListJobsByPipelineResponse.ReadOnly =
    zio.aws.elastictranscoder.model.ListJobsByPipelineResponse
      .wrap(buildAwsValue())
}
object ListJobsByPipelineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.ListJobsByPipelineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.ListJobsByPipelineResponse =
      zio.aws.elastictranscoder.model.ListJobsByPipelineResponse(
        jobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def jobs: Option[List[zio.aws.elastictranscoder.model.Job.ReadOnly]]
    def nextPageToken: Option[Id]
    def getJobs: ZIO[Any, AwsError, List[
      zio.aws.elastictranscoder.model.Job.ReadOnly
    ]] = AwsError.unwrapOptionField("jobs", jobs)
    def getNextPageToken: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.ListJobsByPipelineResponse
  ) extends zio.aws.elastictranscoder.model.ListJobsByPipelineResponse.ReadOnly {
    override val jobs
        : Option[List[zio.aws.elastictranscoder.model.Job.ReadOnly]] = scala
      .Option(impl.jobs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elastictranscoder.model.Job.wrap(item)
        }.toList
      )
    override val nextPageToken: Option[Id] = scala
      .Option(impl.nextPageToken())
      .map(value => zio.aws.elastictranscoder.model.primitives.Id(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.ListJobsByPipelineResponse
  ): zio.aws.elastictranscoder.model.ListJobsByPipelineResponse.ReadOnly =
    new Wrapper(impl)
}
