package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elastictranscoder.model.primitives.SnsTopic
import scala.jdk.CollectionConverters.*
final case class Notifications(
    progressing: Option[SnsTopic] = None,
    completed: Option[SnsTopic] = None,
    warning: Option[SnsTopic] = None,
    error: Option[SnsTopic] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.Notifications = {
    import Notifications.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.Notifications
      .builder()
      .optionallyWith(
        progressing.map(value => SnsTopic.unwrap(value): java.lang.String)
      )(_.progressing)
      .optionallyWith(
        completed.map(value => SnsTopic.unwrap(value): java.lang.String)
      )(_.completed)
      .optionallyWith(
        warning.map(value => SnsTopic.unwrap(value): java.lang.String)
      )(_.warning)
      .optionallyWith(
        error.map(value => SnsTopic.unwrap(value): java.lang.String)
      )(_.error)
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.Notifications.ReadOnly =
    zio.aws.elastictranscoder.model.Notifications.wrap(buildAwsValue())
}
object Notifications {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.Notifications
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.Notifications =
      zio.aws.elastictranscoder.model.Notifications(
        progressing.map(value => value),
        completed.map(value => value),
        warning.map(value => value),
        error.map(value => value)
      )
    def progressing: Option[SnsTopic]
    def completed: Option[SnsTopic]
    def warning: Option[SnsTopic]
    def error: Option[SnsTopic]
    def getProgressing: ZIO[Any, AwsError, SnsTopic] =
      AwsError.unwrapOptionField("progressing", progressing)
    def getCompleted: ZIO[Any, AwsError, SnsTopic] =
      AwsError.unwrapOptionField("completed", completed)
    def getWarning: ZIO[Any, AwsError, SnsTopic] =
      AwsError.unwrapOptionField("warning", warning)
    def getError: ZIO[Any, AwsError, SnsTopic] =
      AwsError.unwrapOptionField("error", error)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.Notifications
  ) extends zio.aws.elastictranscoder.model.Notifications.ReadOnly {
    override val progressing: Option[SnsTopic] = scala
      .Option(impl.progressing())
      .map(value => zio.aws.elastictranscoder.model.primitives.SnsTopic(value))
    override val completed: Option[SnsTopic] = scala
      .Option(impl.completed())
      .map(value => zio.aws.elastictranscoder.model.primitives.SnsTopic(value))
    override val warning: Option[SnsTopic] = scala
      .Option(impl.warning())
      .map(value => zio.aws.elastictranscoder.model.primitives.SnsTopic(value))
    override val error: Option[SnsTopic] = scala
      .Option(impl.error())
      .map(value => zio.aws.elastictranscoder.model.primitives.SnsTopic(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.Notifications
  ): zio.aws.elastictranscoder.model.Notifications.ReadOnly = new Wrapper(impl)
}
