package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elastictranscoder.model.primitives.{
  Key,
  Rotate,
  FloatString,
  ThumbnailPattern,
  Id
}
import scala.jdk.CollectionConverters.*
final case class CreateJobOutput(
    key: Option[Key] = None,
    thumbnailPattern: Option[ThumbnailPattern] = None,
    thumbnailEncryption: Option[zio.aws.elastictranscoder.model.Encryption] =
      None,
    rotate: Option[Rotate] = None,
    presetId: Option[Id] = None,
    segmentDuration: Option[FloatString] = None,
    watermarks: Option[Iterable[zio.aws.elastictranscoder.model.JobWatermark]] =
      None,
    albumArt: Option[zio.aws.elastictranscoder.model.JobAlbumArt] = None,
    composition: Option[Iterable[zio.aws.elastictranscoder.model.Clip]] = None,
    captions: Option[zio.aws.elastictranscoder.model.Captions] = None,
    encryption: Option[zio.aws.elastictranscoder.model.Encryption] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.CreateJobOutput = {
    import CreateJobOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.CreateJobOutput
      .builder()
      .optionallyWith(key.map(value => Key.unwrap(value): java.lang.String))(
        _.key
      )
      .optionallyWith(
        thumbnailPattern.map(value =>
          ThumbnailPattern.unwrap(value): java.lang.String
        )
      )(_.thumbnailPattern)
      .optionallyWith(thumbnailEncryption.map(value => value.buildAwsValue()))(
        _.thumbnailEncryption
      )
      .optionallyWith(
        rotate.map(value => Rotate.unwrap(value): java.lang.String)
      )(_.rotate)
      .optionallyWith(
        presetId.map(value => Id.unwrap(value): java.lang.String)
      )(_.presetId)
      .optionallyWith(
        segmentDuration.map(value =>
          FloatString.unwrap(value): java.lang.String
        )
      )(_.segmentDuration)
      .optionallyWith(
        watermarks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.watermarks)
      .optionallyWith(albumArt.map(value => value.buildAwsValue()))(_.albumArt)
      .optionallyWith(
        composition.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.composition)
      .optionallyWith(captions.map(value => value.buildAwsValue()))(_.captions)
      .optionallyWith(encryption.map(value => value.buildAwsValue()))(
        _.encryption
      )
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.CreateJobOutput.ReadOnly =
    zio.aws.elastictranscoder.model.CreateJobOutput.wrap(buildAwsValue())
}
object CreateJobOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.CreateJobOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.CreateJobOutput =
      zio.aws.elastictranscoder.model.CreateJobOutput(
        key.map(value => value),
        thumbnailPattern.map(value => value),
        thumbnailEncryption.map(value => value.asEditable),
        rotate.map(value => value),
        presetId.map(value => value),
        segmentDuration.map(value => value),
        watermarks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        albumArt.map(value => value.asEditable),
        composition.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        captions.map(value => value.asEditable),
        encryption.map(value => value.asEditable)
      )
    def key: Option[Key]
    def thumbnailPattern: Option[ThumbnailPattern]
    def thumbnailEncryption
        : Option[zio.aws.elastictranscoder.model.Encryption.ReadOnly]
    def rotate: Option[Rotate]
    def presetId: Option[Id]
    def segmentDuration: Option[FloatString]
    def watermarks
        : Option[List[zio.aws.elastictranscoder.model.JobWatermark.ReadOnly]]
    def albumArt: Option[zio.aws.elastictranscoder.model.JobAlbumArt.ReadOnly]
    def composition: Option[List[zio.aws.elastictranscoder.model.Clip.ReadOnly]]
    def captions: Option[zio.aws.elastictranscoder.model.Captions.ReadOnly]
    def encryption: Option[zio.aws.elastictranscoder.model.Encryption.ReadOnly]
    def getKey: ZIO[Any, AwsError, Key] = AwsError.unwrapOptionField("key", key)
    def getThumbnailPattern: ZIO[Any, AwsError, ThumbnailPattern] =
      AwsError.unwrapOptionField("thumbnailPattern", thumbnailPattern)
    def getThumbnailEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.Encryption.ReadOnly
    ] = AwsError.unwrapOptionField("thumbnailEncryption", thumbnailEncryption)
    def getRotate: ZIO[Any, AwsError, Rotate] =
      AwsError.unwrapOptionField("rotate", rotate)
    def getPresetId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("presetId", presetId)
    def getSegmentDuration: ZIO[Any, AwsError, FloatString] =
      AwsError.unwrapOptionField("segmentDuration", segmentDuration)
    def getWatermarks: ZIO[Any, AwsError, List[
      zio.aws.elastictranscoder.model.JobWatermark.ReadOnly
    ]] = AwsError.unwrapOptionField("watermarks", watermarks)
    def getAlbumArt: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.JobAlbumArt.ReadOnly
    ] = AwsError.unwrapOptionField("albumArt", albumArt)
    def getComposition: ZIO[Any, AwsError, List[
      zio.aws.elastictranscoder.model.Clip.ReadOnly
    ]] = AwsError.unwrapOptionField("composition", composition)
    def getCaptions: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.Captions.ReadOnly
    ] = AwsError.unwrapOptionField("captions", captions)
    def getEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.Encryption.ReadOnly
    ] = AwsError.unwrapOptionField("encryption", encryption)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.CreateJobOutput
  ) extends zio.aws.elastictranscoder.model.CreateJobOutput.ReadOnly {
    override val key: Option[Key] = scala
      .Option(impl.key())
      .map(value => zio.aws.elastictranscoder.model.primitives.Key(value))
    override val thumbnailPattern: Option[ThumbnailPattern] = scala
      .Option(impl.thumbnailPattern())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.ThumbnailPattern(value)
      )
    override val thumbnailEncryption
        : Option[zio.aws.elastictranscoder.model.Encryption.ReadOnly] = scala
      .Option(impl.thumbnailEncryption())
      .map(value => zio.aws.elastictranscoder.model.Encryption.wrap(value))
    override val rotate: Option[Rotate] = scala
      .Option(impl.rotate())
      .map(value => zio.aws.elastictranscoder.model.primitives.Rotate(value))
    override val presetId: Option[Id] = scala
      .Option(impl.presetId())
      .map(value => zio.aws.elastictranscoder.model.primitives.Id(value))
    override val segmentDuration: Option[FloatString] = scala
      .Option(impl.segmentDuration())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.FloatString(value)
      )
    override val watermarks
        : Option[List[zio.aws.elastictranscoder.model.JobWatermark.ReadOnly]] =
      scala
        .Option(impl.watermarks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elastictranscoder.model.JobWatermark.wrap(item)
          }.toList
        )
    override val albumArt
        : Option[zio.aws.elastictranscoder.model.JobAlbumArt.ReadOnly] = scala
      .Option(impl.albumArt())
      .map(value => zio.aws.elastictranscoder.model.JobAlbumArt.wrap(value))
    override val composition
        : Option[List[zio.aws.elastictranscoder.model.Clip.ReadOnly]] = scala
      .Option(impl.composition())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elastictranscoder.model.Clip.wrap(item)
        }.toList
      )
    override val captions
        : Option[zio.aws.elastictranscoder.model.Captions.ReadOnly] = scala
      .Option(impl.captions())
      .map(value => zio.aws.elastictranscoder.model.Captions.wrap(value))
    override val encryption
        : Option[zio.aws.elastictranscoder.model.Encryption.ReadOnly] = scala
      .Option(impl.encryption())
      .map(value => zio.aws.elastictranscoder.model.Encryption.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.CreateJobOutput
  ): zio.aws.elastictranscoder.model.CreateJobOutput.ReadOnly = new Wrapper(
    impl
  )
}
