package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elastictranscoder.model.primitives.Time
import scala.jdk.CollectionConverters.*
final case class TimeSpan(
    startTime: Option[Time] = None,
    duration: Option[Time] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.TimeSpan = {
    import TimeSpan.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.TimeSpan
      .builder()
      .optionallyWith(
        startTime.map(value => Time.unwrap(value): java.lang.String)
      )(_.startTime)
      .optionallyWith(
        duration.map(value => Time.unwrap(value): java.lang.String)
      )(_.duration)
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.TimeSpan.ReadOnly =
    zio.aws.elastictranscoder.model.TimeSpan.wrap(buildAwsValue())
}
object TimeSpan {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.TimeSpan
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.TimeSpan =
      zio.aws.elastictranscoder.model
        .TimeSpan(startTime.map(value => value), duration.map(value => value))
    def startTime: Option[Time]
    def duration: Option[Time]
    def getStartTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getDuration: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("duration", duration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.TimeSpan
  ) extends zio.aws.elastictranscoder.model.TimeSpan.ReadOnly {
    override val startTime: Option[Time] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.elastictranscoder.model.primitives.Time(value))
    override val duration: Option[Time] = scala
      .Option(impl.duration())
      .map(value => zio.aws.elastictranscoder.model.primitives.Time(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.TimeSpan
  ): zio.aws.elastictranscoder.model.TimeSpan.ReadOnly = new Wrapper(impl)
}
