package zio.aws.elastictranscoder
import software.amazon.awssdk.services.elastictranscoder.paginators.{
  ListPipelinesPublisher,
  ListJobsByStatusPublisher,
  ListJobsByPipelinePublisher,
  ListPresetsPublisher
}
import zio.aws.elastictranscoder.model.ReadPipelineResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.elastictranscoder.model.{
  ListPresetsRequest,
  ReadPipelineRequest,
  CreatePresetRequest,
  CancelJobRequest,
  UpdatePipelineNotificationsRequest,
  ListPipelinesRequest,
  DeletePipelineRequest,
  UpdatePipelineStatusRequest,
  ReadPresetRequest,
  ListJobsByStatusRequest,
  CreateJobRequest,
  CreatePipelineRequest,
  UpdatePipelineRequest,
  ListJobsByPipelineRequest,
  ReadJobRequest,
  DeletePresetRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import software.amazon.awssdk.services.elastictranscoder.model.{
  CreatePresetResponse,
  DeletePresetResponse,
  ReadPipelineResponse,
  CancelJobResponse,
  ReadPresetResponse,
  UpdatePipelineResponse,
  ListPipelinesResponse,
  Job,
  CreatePipelineResponse,
  UpdatePipelineStatusResponse,
  UpdatePipelineNotificationsResponse,
  Pipeline,
  ListJobsByPipelineResponse,
  ListJobsByStatusResponse,
  ListPresetsResponse,
  Preset,
  DeletePipelineResponse,
  ReadJobResponse,
  CreateJobResponse
}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.elastictranscoder.{
  ElasticTranscoderAsyncClientBuilder,
  ElasticTranscoderAsyncClient
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait ElasticTranscoder extends AspectSupport[ElasticTranscoder] {
  val api: ElasticTranscoderAsyncClient
  def listPresets(
      request: ListPresetsRequest
  ): ZStream[Any, AwsError, zio.aws.elastictranscoder.model.Preset.ReadOnly]
  def listPresetsPaginated(
      request: ListPresetsRequest
  ): IO[AwsError, zio.aws.elastictranscoder.model.ListPresetsResponse.ReadOnly]
  def listJobsByPipeline(
      request: ListJobsByPipelineRequest
  ): ZStream[Any, AwsError, zio.aws.elastictranscoder.model.Job.ReadOnly]
  def listJobsByPipelinePaginated(request: ListJobsByPipelineRequest): IO[
    AwsError,
    zio.aws.elastictranscoder.model.ListJobsByPipelineResponse.ReadOnly
  ]
  def listJobsByStatus(
      request: ListJobsByStatusRequest
  ): ZStream[Any, AwsError, zio.aws.elastictranscoder.model.Job.ReadOnly]
  def listJobsByStatusPaginated(request: ListJobsByStatusRequest): IO[
    AwsError,
    zio.aws.elastictranscoder.model.ListJobsByStatusResponse.ReadOnly
  ]
  def updatePipeline(request: UpdatePipelineRequest): IO[
    AwsError,
    zio.aws.elastictranscoder.model.UpdatePipelineResponse.ReadOnly
  ]
  def createJob(
      request: CreateJobRequest
  ): IO[AwsError, zio.aws.elastictranscoder.model.CreateJobResponse.ReadOnly]
  def cancelJob(
      request: CancelJobRequest
  ): IO[AwsError, zio.aws.elastictranscoder.model.CancelJobResponse.ReadOnly]
  def listPipelines(
      request: ListPipelinesRequest
  ): ZStream[Any, AwsError, zio.aws.elastictranscoder.model.Pipeline.ReadOnly]
  def listPipelinesPaginated(request: ListPipelinesRequest): IO[
    AwsError,
    zio.aws.elastictranscoder.model.ListPipelinesResponse.ReadOnly
  ]
  def readPipeline(request: ReadPipelineRequest): IO[AwsError, ReadOnly]
  def deletePreset(
      request: DeletePresetRequest
  ): IO[AwsError, zio.aws.elastictranscoder.model.DeletePresetResponse.ReadOnly]
  def updatePipelineStatus(request: UpdatePipelineStatusRequest): IO[
    AwsError,
    zio.aws.elastictranscoder.model.UpdatePipelineStatusResponse.ReadOnly
  ]
  def createPreset(
      request: CreatePresetRequest
  ): IO[AwsError, zio.aws.elastictranscoder.model.CreatePresetResponse.ReadOnly]
  def deletePipeline(request: DeletePipelineRequest): IO[
    AwsError,
    zio.aws.elastictranscoder.model.DeletePipelineResponse.ReadOnly
  ]
  def readJob(
      request: ReadJobRequest
  ): IO[AwsError, zio.aws.elastictranscoder.model.ReadJobResponse.ReadOnly]
  def updatePipelineNotifications(
      request: UpdatePipelineNotificationsRequest
  ): IO[
    AwsError,
    zio.aws.elastictranscoder.model.UpdatePipelineNotificationsResponse.ReadOnly
  ]
  def createPipeline(request: CreatePipelineRequest): IO[
    AwsError,
    zio.aws.elastictranscoder.model.CreatePipelineResponse.ReadOnly
  ]
  def readPreset(
      request: ReadPresetRequest
  ): IO[AwsError, zio.aws.elastictranscoder.model.ReadPresetResponse.ReadOnly]
}
object ElasticTranscoder {
  val live: ZLayer[AwsConfig, java.lang.Throwable, ElasticTranscoder] =
    customized(identity)
  def customized(
      customization: ElasticTranscoderAsyncClientBuilder => ElasticTranscoderAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, ElasticTranscoder] = managed(
    customization
  ).toLayer
  def managed(
      customization: ElasticTranscoderAsyncClientBuilder => ElasticTranscoderAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, ElasticTranscoder] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = ElasticTranscoderAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[
        ElasticTranscoderAsyncClient,
        ElasticTranscoderAsyncClientBuilder
      ](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        ElasticTranscoderAsyncClient,
        ElasticTranscoderAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new ElasticTranscoderImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class ElasticTranscoderImpl[R](
      override val api: ElasticTranscoderAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends ElasticTranscoder
      with AwsServiceBase[R] {
    override val serviceName: String = "ElasticTranscoder"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): ElasticTranscoderImpl[R1] = new ElasticTranscoderImpl(api, newAspect, r)
    def listPresets(request: ListPresetsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.Preset.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.elastictranscoder.model.ListPresetsRequest,
      Preset,
      ListPresetsPublisher
    ]("listPresets", api.listPresetsPaginator, _.presets())(
      request.buildAwsValue()
    ).map(item => zio.aws.elastictranscoder.model.Preset.wrap(item))
      .provideEnvironment(r)
    def listPresetsPaginated(request: ListPresetsRequest): IO[
      AwsError,
      zio.aws.elastictranscoder.model.ListPresetsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elastictranscoder.model.ListPresetsRequest,
      ListPresetsResponse
    ]("listPresets", api.listPresets)(request.buildAwsValue())
      .map(zio.aws.elastictranscoder.model.ListPresetsResponse.wrap)
      .provideEnvironment(r)
    def listJobsByPipeline(
        request: ListJobsByPipelineRequest
    ): ZStream[Any, AwsError, zio.aws.elastictranscoder.model.Job.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.elastictranscoder.model.ListJobsByPipelineRequest,
        Job,
        ListJobsByPipelinePublisher
      ]("listJobsByPipeline", api.listJobsByPipelinePaginator, _.jobs())(
        request.buildAwsValue()
      ).map(item => zio.aws.elastictranscoder.model.Job.wrap(item))
        .provideEnvironment(r)
    def listJobsByPipelinePaginated(request: ListJobsByPipelineRequest): IO[
      AwsError,
      zio.aws.elastictranscoder.model.ListJobsByPipelineResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elastictranscoder.model.ListJobsByPipelineRequest,
      ListJobsByPipelineResponse
    ]("listJobsByPipeline", api.listJobsByPipeline)(request.buildAwsValue())
      .map(zio.aws.elastictranscoder.model.ListJobsByPipelineResponse.wrap)
      .provideEnvironment(r)
    def listJobsByStatus(
        request: ListJobsByStatusRequest
    ): ZStream[Any, AwsError, zio.aws.elastictranscoder.model.Job.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.elastictranscoder.model.ListJobsByStatusRequest,
        Job,
        ListJobsByStatusPublisher
      ]("listJobsByStatus", api.listJobsByStatusPaginator, _.jobs())(
        request.buildAwsValue()
      ).map(item => zio.aws.elastictranscoder.model.Job.wrap(item))
        .provideEnvironment(r)
    def listJobsByStatusPaginated(request: ListJobsByStatusRequest): IO[
      AwsError,
      zio.aws.elastictranscoder.model.ListJobsByStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elastictranscoder.model.ListJobsByStatusRequest,
      ListJobsByStatusResponse
    ]("listJobsByStatus", api.listJobsByStatus)(request.buildAwsValue())
      .map(zio.aws.elastictranscoder.model.ListJobsByStatusResponse.wrap)
      .provideEnvironment(r)
    def updatePipeline(request: UpdatePipelineRequest): IO[
      AwsError,
      zio.aws.elastictranscoder.model.UpdatePipelineResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineRequest,
      UpdatePipelineResponse
    ]("updatePipeline", api.updatePipeline)(request.buildAwsValue())
      .map(zio.aws.elastictranscoder.model.UpdatePipelineResponse.wrap)
      .provideEnvironment(r)
    def createJob(request: CreateJobRequest): IO[
      AwsError,
      zio.aws.elastictranscoder.model.CreateJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elastictranscoder.model.CreateJobRequest,
      CreateJobResponse
    ]("createJob", api.createJob)(request.buildAwsValue())
      .map(zio.aws.elastictranscoder.model.CreateJobResponse.wrap)
      .provideEnvironment(r)
    def cancelJob(request: CancelJobRequest): IO[
      AwsError,
      zio.aws.elastictranscoder.model.CancelJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elastictranscoder.model.CancelJobRequest,
      CancelJobResponse
    ]("cancelJob", api.cancelJob)(request.buildAwsValue())
      .map(zio.aws.elastictranscoder.model.CancelJobResponse.wrap)
      .provideEnvironment(r)
    def listPipelines(request: ListPipelinesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.Pipeline.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.elastictranscoder.model.ListPipelinesRequest,
      Pipeline,
      ListPipelinesPublisher
    ]("listPipelines", api.listPipelinesPaginator, _.pipelines())(
      request.buildAwsValue()
    ).map(item => zio.aws.elastictranscoder.model.Pipeline.wrap(item))
      .provideEnvironment(r)
    def listPipelinesPaginated(request: ListPipelinesRequest): IO[
      AwsError,
      zio.aws.elastictranscoder.model.ListPipelinesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elastictranscoder.model.ListPipelinesRequest,
      ListPipelinesResponse
    ]("listPipelines", api.listPipelines)(request.buildAwsValue())
      .map(zio.aws.elastictranscoder.model.ListPipelinesResponse.wrap)
      .provideEnvironment(r)
    def readPipeline(request: ReadPipelineRequest): IO[AwsError, ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.elastictranscoder.model.ReadPipelineRequest,
        ReadPipelineResponse
      ]("readPipeline", api.readPipeline)(request.buildAwsValue())
        .map(zio.aws.elastictranscoder.model.ReadPipelineResponse.wrap)
        .provideEnvironment(r)
    def deletePreset(request: DeletePresetRequest): IO[
      AwsError,
      zio.aws.elastictranscoder.model.DeletePresetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elastictranscoder.model.DeletePresetRequest,
      DeletePresetResponse
    ]("deletePreset", api.deletePreset)(request.buildAwsValue())
      .map(zio.aws.elastictranscoder.model.DeletePresetResponse.wrap)
      .provideEnvironment(r)
    def updatePipelineStatus(request: UpdatePipelineStatusRequest): IO[
      AwsError,
      zio.aws.elastictranscoder.model.UpdatePipelineStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineStatusRequest,
      UpdatePipelineStatusResponse
    ]("updatePipelineStatus", api.updatePipelineStatus)(request.buildAwsValue())
      .map(zio.aws.elastictranscoder.model.UpdatePipelineStatusResponse.wrap)
      .provideEnvironment(r)
    def createPreset(request: CreatePresetRequest): IO[
      AwsError,
      zio.aws.elastictranscoder.model.CreatePresetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elastictranscoder.model.CreatePresetRequest,
      CreatePresetResponse
    ]("createPreset", api.createPreset)(request.buildAwsValue())
      .map(zio.aws.elastictranscoder.model.CreatePresetResponse.wrap)
      .provideEnvironment(r)
    def deletePipeline(request: DeletePipelineRequest): IO[
      AwsError,
      zio.aws.elastictranscoder.model.DeletePipelineResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elastictranscoder.model.DeletePipelineRequest,
      DeletePipelineResponse
    ]("deletePipeline", api.deletePipeline)(request.buildAwsValue())
      .map(zio.aws.elastictranscoder.model.DeletePipelineResponse.wrap)
      .provideEnvironment(r)
    def readJob(
        request: ReadJobRequest
    ): IO[AwsError, zio.aws.elastictranscoder.model.ReadJobResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.elastictranscoder.model.ReadJobRequest,
        ReadJobResponse
      ]("readJob", api.readJob)(request.buildAwsValue())
        .map(zio.aws.elastictranscoder.model.ReadJobResponse.wrap)
        .provideEnvironment(r)
    def updatePipelineNotifications(
        request: UpdatePipelineNotificationsRequest
    ): IO[
      AwsError,
      zio.aws.elastictranscoder.model.UpdatePipelineNotificationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineNotificationsRequest,
      UpdatePipelineNotificationsResponse
    ]("updatePipelineNotifications", api.updatePipelineNotifications)(
      request.buildAwsValue()
    ).map(
      zio.aws.elastictranscoder.model.UpdatePipelineNotificationsResponse.wrap
    ).provideEnvironment(r)
    def createPipeline(request: CreatePipelineRequest): IO[
      AwsError,
      zio.aws.elastictranscoder.model.CreatePipelineResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elastictranscoder.model.CreatePipelineRequest,
      CreatePipelineResponse
    ]("createPipeline", api.createPipeline)(request.buildAwsValue())
      .map(zio.aws.elastictranscoder.model.CreatePipelineResponse.wrap)
      .provideEnvironment(r)
    def readPreset(request: ReadPresetRequest): IO[
      AwsError,
      zio.aws.elastictranscoder.model.ReadPresetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elastictranscoder.model.ReadPresetRequest,
      ReadPresetResponse
    ]("readPreset", api.readPreset)(request.buildAwsValue())
      .map(zio.aws.elastictranscoder.model.ReadPresetResponse.wrap)
      .provideEnvironment(r)
  }
  def listPresets(request: ListPresetsRequest): ZStream[
    zio.aws.elastictranscoder.ElasticTranscoder,
    AwsError,
    zio.aws.elastictranscoder.model.Preset.ReadOnly
  ] = ZStream.serviceWithStream(_.listPresets(request))
  def listPresetsPaginated(request: ListPresetsRequest): ZIO[
    zio.aws.elastictranscoder.ElasticTranscoder,
    AwsError,
    zio.aws.elastictranscoder.model.ListPresetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPresetsPaginated(request))
  def listJobsByPipeline(request: ListJobsByPipelineRequest): ZStream[
    zio.aws.elastictranscoder.ElasticTranscoder,
    AwsError,
    zio.aws.elastictranscoder.model.Job.ReadOnly
  ] = ZStream.serviceWithStream(_.listJobsByPipeline(request))
  def listJobsByPipelinePaginated(request: ListJobsByPipelineRequest): ZIO[
    zio.aws.elastictranscoder.ElasticTranscoder,
    AwsError,
    zio.aws.elastictranscoder.model.ListJobsByPipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listJobsByPipelinePaginated(request))
  def listJobsByStatus(request: ListJobsByStatusRequest): ZStream[
    zio.aws.elastictranscoder.ElasticTranscoder,
    AwsError,
    zio.aws.elastictranscoder.model.Job.ReadOnly
  ] = ZStream.serviceWithStream(_.listJobsByStatus(request))
  def listJobsByStatusPaginated(request: ListJobsByStatusRequest): ZIO[
    zio.aws.elastictranscoder.ElasticTranscoder,
    AwsError,
    zio.aws.elastictranscoder.model.ListJobsByStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listJobsByStatusPaginated(request))
  def updatePipeline(request: UpdatePipelineRequest): ZIO[
    zio.aws.elastictranscoder.ElasticTranscoder,
    AwsError,
    zio.aws.elastictranscoder.model.UpdatePipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updatePipeline(request))
  def createJob(request: CreateJobRequest): ZIO[
    zio.aws.elastictranscoder.ElasticTranscoder,
    AwsError,
    zio.aws.elastictranscoder.model.CreateJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createJob(request))
  def cancelJob(request: CancelJobRequest): ZIO[
    zio.aws.elastictranscoder.ElasticTranscoder,
    AwsError,
    zio.aws.elastictranscoder.model.CancelJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelJob(request))
  def listPipelines(request: ListPipelinesRequest): ZStream[
    zio.aws.elastictranscoder.ElasticTranscoder,
    AwsError,
    zio.aws.elastictranscoder.model.Pipeline.ReadOnly
  ] = ZStream.serviceWithStream(_.listPipelines(request))
  def listPipelinesPaginated(request: ListPipelinesRequest): ZIO[
    zio.aws.elastictranscoder.ElasticTranscoder,
    AwsError,
    zio.aws.elastictranscoder.model.ListPipelinesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPipelinesPaginated(request))
  def readPipeline(
      request: ReadPipelineRequest
  ): ZIO[zio.aws.elastictranscoder.ElasticTranscoder, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.readPipeline(request))
  def deletePreset(request: DeletePresetRequest): ZIO[
    zio.aws.elastictranscoder.ElasticTranscoder,
    AwsError,
    zio.aws.elastictranscoder.model.DeletePresetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deletePreset(request))
  def updatePipelineStatus(request: UpdatePipelineStatusRequest): ZIO[
    zio.aws.elastictranscoder.ElasticTranscoder,
    AwsError,
    zio.aws.elastictranscoder.model.UpdatePipelineStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updatePipelineStatus(request))
  def createPreset(request: CreatePresetRequest): ZIO[
    zio.aws.elastictranscoder.ElasticTranscoder,
    AwsError,
    zio.aws.elastictranscoder.model.CreatePresetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPreset(request))
  def deletePipeline(request: DeletePipelineRequest): ZIO[
    zio.aws.elastictranscoder.ElasticTranscoder,
    AwsError,
    zio.aws.elastictranscoder.model.DeletePipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deletePipeline(request))
  def readJob(request: ReadJobRequest): ZIO[
    zio.aws.elastictranscoder.ElasticTranscoder,
    AwsError,
    zio.aws.elastictranscoder.model.ReadJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.readJob(request))
  def updatePipelineNotifications(
      request: UpdatePipelineNotificationsRequest
  ): ZIO[
    zio.aws.elastictranscoder.ElasticTranscoder,
    AwsError,
    zio.aws.elastictranscoder.model.UpdatePipelineNotificationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updatePipelineNotifications(request))
  def createPipeline(request: CreatePipelineRequest): ZIO[
    zio.aws.elastictranscoder.ElasticTranscoder,
    AwsError,
    zio.aws.elastictranscoder.model.CreatePipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPipeline(request))
  def readPreset(request: ReadPresetRequest): ZIO[
    zio.aws.elastictranscoder.ElasticTranscoder,
    AwsError,
    zio.aws.elastictranscoder.model.ReadPresetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.readPreset(request))
}
