package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreatePresetResponse(
    preset: Option[zio.aws.elastictranscoder.model.Preset] = None,
    warning: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.CreatePresetResponse = {
    import CreatePresetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.CreatePresetResponse
      .builder()
      .optionallyWith(preset.map(value => value.buildAwsValue()))(_.preset)
      .optionallyWith(warning.map(value => value: java.lang.String))(_.warning)
      .build()
  }
  def asReadOnly
      : zio.aws.elastictranscoder.model.CreatePresetResponse.ReadOnly =
    zio.aws.elastictranscoder.model.CreatePresetResponse.wrap(buildAwsValue())
}
object CreatePresetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.CreatePresetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.CreatePresetResponse =
      zio.aws.elastictranscoder.model.CreatePresetResponse(
        preset.map(value => value.asEditable),
        warning.map(value => value)
      )
    def preset: Option[zio.aws.elastictranscoder.model.Preset.ReadOnly]
    def warning: Option[String]
    def getPreset
        : ZIO[Any, AwsError, zio.aws.elastictranscoder.model.Preset.ReadOnly] =
      AwsError.unwrapOptionField("preset", preset)
    def getWarning: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("warning", warning)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.CreatePresetResponse
  ) extends zio.aws.elastictranscoder.model.CreatePresetResponse.ReadOnly {
    override val preset
        : Option[zio.aws.elastictranscoder.model.Preset.ReadOnly] = scala
      .Option(impl.preset())
      .map(value => zio.aws.elastictranscoder.model.Preset.wrap(value))
    override val warning: Option[String] =
      scala.Option(impl.warning()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.CreatePresetResponse
  ): zio.aws.elastictranscoder.model.CreatePresetResponse.ReadOnly =
    new Wrapper(impl)
}
