package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdatePipelineNotificationsResponse(
    pipeline: Option[zio.aws.elastictranscoder.model.Pipeline] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineNotificationsResponse = {
    import UpdatePipelineNotificationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineNotificationsResponse
      .builder()
      .optionallyWith(pipeline.map(value => value.buildAwsValue()))(_.pipeline)
      .build()
  }
  def asReadOnly
      : zio.aws.elastictranscoder.model.UpdatePipelineNotificationsResponse.ReadOnly =
    zio.aws.elastictranscoder.model.UpdatePipelineNotificationsResponse
      .wrap(buildAwsValue())
}
object UpdatePipelineNotificationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineNotificationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elastictranscoder.model.UpdatePipelineNotificationsResponse =
      zio.aws.elastictranscoder.model.UpdatePipelineNotificationsResponse(
        pipeline.map(value => value.asEditable)
      )
    def pipeline: Option[zio.aws.elastictranscoder.model.Pipeline.ReadOnly]
    def getPipeline: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.Pipeline.ReadOnly
    ] = AwsError.unwrapOptionField("pipeline", pipeline)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineNotificationsResponse
  ) extends zio.aws.elastictranscoder.model.UpdatePipelineNotificationsResponse.ReadOnly {
    override val pipeline
        : Option[zio.aws.elastictranscoder.model.Pipeline.ReadOnly] = scala
      .Option(impl.pipeline())
      .map(value => zio.aws.elastictranscoder.model.Pipeline.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineNotificationsResponse
  ): zio.aws.elastictranscoder.model.UpdatePipelineNotificationsResponse.ReadOnly =
    new Wrapper(impl)
}
