package zio.aws.elastictranscoder.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elastictranscoder.model.primitives.{
  NullableLong,
  FloatString,
  NullableInteger
}
import scala.jdk.CollectionConverters.*
final case class DetectedProperties(
    width: Option[NullableInteger] = None,
    height: Option[NullableInteger] = None,
    frameRate: Option[FloatString] = None,
    fileSize: Option[NullableLong] = None,
    durationMillis: Option[NullableLong] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.DetectedProperties = {
    import DetectedProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.DetectedProperties
      .builder()
      .optionallyWith(
        width.map(value => NullableInteger.unwrap(value): Integer)
      )(_.width)
      .optionallyWith(
        height.map(value => NullableInteger.unwrap(value): Integer)
      )(_.height)
      .optionallyWith(
        frameRate.map(value => FloatString.unwrap(value): java.lang.String)
      )(_.frameRate)
      .optionallyWith(
        fileSize.map(value => NullableLong.unwrap(value): java.lang.Long)
      )(_.fileSize)
      .optionallyWith(
        durationMillis.map(value => NullableLong.unwrap(value): java.lang.Long)
      )(_.durationMillis)
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.DetectedProperties.ReadOnly =
    zio.aws.elastictranscoder.model.DetectedProperties.wrap(buildAwsValue())
}
object DetectedProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.DetectedProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.DetectedProperties =
      zio.aws.elastictranscoder.model.DetectedProperties(
        width.map(value => value),
        height.map(value => value),
        frameRate.map(value => value),
        fileSize.map(value => value),
        durationMillis.map(value => value)
      )
    def width: Option[NullableInteger]
    def height: Option[NullableInteger]
    def frameRate: Option[FloatString]
    def fileSize: Option[NullableLong]
    def durationMillis: Option[NullableLong]
    def getWidth: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("width", width)
    def getHeight: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("height", height)
    def getFrameRate: ZIO[Any, AwsError, FloatString] =
      AwsError.unwrapOptionField("frameRate", frameRate)
    def getFileSize: ZIO[Any, AwsError, NullableLong] =
      AwsError.unwrapOptionField("fileSize", fileSize)
    def getDurationMillis: ZIO[Any, AwsError, NullableLong] =
      AwsError.unwrapOptionField("durationMillis", durationMillis)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.DetectedProperties
  ) extends zio.aws.elastictranscoder.model.DetectedProperties.ReadOnly {
    override val width: Option[NullableInteger] = scala
      .Option(impl.width())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.NullableInteger(value)
      )
    override val height: Option[NullableInteger] = scala
      .Option(impl.height())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.NullableInteger(value)
      )
    override val frameRate: Option[FloatString] = scala
      .Option(impl.frameRate())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.FloatString(value)
      )
    override val fileSize: Option[NullableLong] = scala
      .Option(impl.fileSize())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.NullableLong(value)
      )
    override val durationMillis: Option[NullableLong] = scala
      .Option(impl.durationMillis())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.NullableLong(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.DetectedProperties
  ): zio.aws.elastictranscoder.model.DetectedProperties.ReadOnly = new Wrapper(
    impl
  )
}
