package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ReadPipelineResponse(
    pipeline: Option[zio.aws.elastictranscoder.model.Pipeline] = None,
    warnings: Option[Iterable[zio.aws.elastictranscoder.model.Warning]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.ReadPipelineResponse = {
    import ReadPipelineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.ReadPipelineResponse
      .builder()
      .optionallyWith(pipeline.map(value => value.buildAwsValue()))(_.pipeline)
      .optionallyWith(
        warnings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.warnings)
      .build()
  }
  def asReadOnly
      : zio.aws.elastictranscoder.model.ReadPipelineResponse.ReadOnly =
    zio.aws.elastictranscoder.model.ReadPipelineResponse.wrap(buildAwsValue())
}
object ReadPipelineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.ReadPipelineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.ReadPipelineResponse =
      zio.aws.elastictranscoder.model.ReadPipelineResponse(
        pipeline.map(value => value.asEditable),
        warnings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def pipeline: Option[zio.aws.elastictranscoder.model.Pipeline.ReadOnly]
    def warnings: Option[List[zio.aws.elastictranscoder.model.Warning.ReadOnly]]
    def getPipeline: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.Pipeline.ReadOnly
    ] = AwsError.unwrapOptionField("pipeline", pipeline)
    def getWarnings: ZIO[Any, AwsError, List[
      zio.aws.elastictranscoder.model.Warning.ReadOnly
    ]] = AwsError.unwrapOptionField("warnings", warnings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.ReadPipelineResponse
  ) extends zio.aws.elastictranscoder.model.ReadPipelineResponse.ReadOnly {
    override val pipeline
        : Option[zio.aws.elastictranscoder.model.Pipeline.ReadOnly] = scala
      .Option(impl.pipeline())
      .map(value => zio.aws.elastictranscoder.model.Pipeline.wrap(value))
    override val warnings
        : Option[List[zio.aws.elastictranscoder.model.Warning.ReadOnly]] = scala
      .Option(impl.warnings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elastictranscoder.model.Warning.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.ReadPipelineResponse
  ): zio.aws.elastictranscoder.model.ReadPipelineResponse.ReadOnly =
    new Wrapper(impl)
}
