package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elastictranscoder.model.primitives.{
  VerticalAlign,
  Opacity,
  PixelsOrPercent,
  PresetWatermarkId,
  Target,
  HorizontalAlign,
  WatermarkSizingPolicy
}
import scala.jdk.CollectionConverters.*
final case class PresetWatermark(
    id: Option[PresetWatermarkId] = None,
    maxWidth: Option[PixelsOrPercent] = None,
    maxHeight: Option[PixelsOrPercent] = None,
    sizingPolicy: Option[WatermarkSizingPolicy] = None,
    horizontalAlign: Option[HorizontalAlign] = None,
    horizontalOffset: Option[PixelsOrPercent] = None,
    verticalAlign: Option[VerticalAlign] = None,
    verticalOffset: Option[PixelsOrPercent] = None,
    opacity: Option[Opacity] = None,
    target: Option[Target] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.PresetWatermark = {
    import PresetWatermark.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.PresetWatermark
      .builder()
      .optionallyWith(
        id.map(value => PresetWatermarkId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        maxWidth.map(value => PixelsOrPercent.unwrap(value): java.lang.String)
      )(_.maxWidth)
      .optionallyWith(
        maxHeight.map(value => PixelsOrPercent.unwrap(value): java.lang.String)
      )(_.maxHeight)
      .optionallyWith(
        sizingPolicy.map(value =>
          WatermarkSizingPolicy.unwrap(value): java.lang.String
        )
      )(_.sizingPolicy)
      .optionallyWith(
        horizontalAlign.map(value =>
          HorizontalAlign.unwrap(value): java.lang.String
        )
      )(_.horizontalAlign)
      .optionallyWith(
        horizontalOffset.map(value =>
          PixelsOrPercent.unwrap(value): java.lang.String
        )
      )(_.horizontalOffset)
      .optionallyWith(
        verticalAlign.map(value =>
          VerticalAlign.unwrap(value): java.lang.String
        )
      )(_.verticalAlign)
      .optionallyWith(
        verticalOffset.map(value =>
          PixelsOrPercent.unwrap(value): java.lang.String
        )
      )(_.verticalOffset)
      .optionallyWith(
        opacity.map(value => Opacity.unwrap(value): java.lang.String)
      )(_.opacity)
      .optionallyWith(
        target.map(value => Target.unwrap(value): java.lang.String)
      )(_.target)
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.PresetWatermark.ReadOnly =
    zio.aws.elastictranscoder.model.PresetWatermark.wrap(buildAwsValue())
}
object PresetWatermark {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.PresetWatermark
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.PresetWatermark =
      zio.aws.elastictranscoder.model.PresetWatermark(
        id.map(value => value),
        maxWidth.map(value => value),
        maxHeight.map(value => value),
        sizingPolicy.map(value => value),
        horizontalAlign.map(value => value),
        horizontalOffset.map(value => value),
        verticalAlign.map(value => value),
        verticalOffset.map(value => value),
        opacity.map(value => value),
        target.map(value => value)
      )
    def id: Option[PresetWatermarkId]
    def maxWidth: Option[PixelsOrPercent]
    def maxHeight: Option[PixelsOrPercent]
    def sizingPolicy: Option[WatermarkSizingPolicy]
    def horizontalAlign: Option[HorizontalAlign]
    def horizontalOffset: Option[PixelsOrPercent]
    def verticalAlign: Option[VerticalAlign]
    def verticalOffset: Option[PixelsOrPercent]
    def opacity: Option[Opacity]
    def target: Option[Target]
    def getId: ZIO[Any, AwsError, PresetWatermarkId] =
      AwsError.unwrapOptionField("id", id)
    def getMaxWidth: ZIO[Any, AwsError, PixelsOrPercent] =
      AwsError.unwrapOptionField("maxWidth", maxWidth)
    def getMaxHeight: ZIO[Any, AwsError, PixelsOrPercent] =
      AwsError.unwrapOptionField("maxHeight", maxHeight)
    def getSizingPolicy: ZIO[Any, AwsError, WatermarkSizingPolicy] =
      AwsError.unwrapOptionField("sizingPolicy", sizingPolicy)
    def getHorizontalAlign: ZIO[Any, AwsError, HorizontalAlign] =
      AwsError.unwrapOptionField("horizontalAlign", horizontalAlign)
    def getHorizontalOffset: ZIO[Any, AwsError, PixelsOrPercent] =
      AwsError.unwrapOptionField("horizontalOffset", horizontalOffset)
    def getVerticalAlign: ZIO[Any, AwsError, VerticalAlign] =
      AwsError.unwrapOptionField("verticalAlign", verticalAlign)
    def getVerticalOffset: ZIO[Any, AwsError, PixelsOrPercent] =
      AwsError.unwrapOptionField("verticalOffset", verticalOffset)
    def getOpacity: ZIO[Any, AwsError, Opacity] =
      AwsError.unwrapOptionField("opacity", opacity)
    def getTarget: ZIO[Any, AwsError, Target] =
      AwsError.unwrapOptionField("target", target)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.PresetWatermark
  ) extends zio.aws.elastictranscoder.model.PresetWatermark.ReadOnly {
    override val id: Option[PresetWatermarkId] = scala
      .Option(impl.id())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.PresetWatermarkId(value)
      )
    override val maxWidth: Option[PixelsOrPercent] = scala
      .Option(impl.maxWidth())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.PixelsOrPercent(value)
      )
    override val maxHeight: Option[PixelsOrPercent] = scala
      .Option(impl.maxHeight())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.PixelsOrPercent(value)
      )
    override val sizingPolicy: Option[WatermarkSizingPolicy] = scala
      .Option(impl.sizingPolicy())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.WatermarkSizingPolicy(value)
      )
    override val horizontalAlign: Option[HorizontalAlign] = scala
      .Option(impl.horizontalAlign())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.HorizontalAlign(value)
      )
    override val horizontalOffset: Option[PixelsOrPercent] = scala
      .Option(impl.horizontalOffset())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.PixelsOrPercent(value)
      )
    override val verticalAlign: Option[VerticalAlign] = scala
      .Option(impl.verticalAlign())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.VerticalAlign(value)
      )
    override val verticalOffset: Option[PixelsOrPercent] = scala
      .Option(impl.verticalOffset())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.PixelsOrPercent(value)
      )
    override val opacity: Option[Opacity] = scala
      .Option(impl.opacity())
      .map(value => zio.aws.elastictranscoder.model.primitives.Opacity(value))
    override val target: Option[Target] = scala
      .Option(impl.target())
      .map(value => zio.aws.elastictranscoder.model.primitives.Target(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.PresetWatermark
  ): zio.aws.elastictranscoder.model.PresetWatermark.ReadOnly = new Wrapper(
    impl
  )
}
