package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elastictranscoder.model.primitives.NullableLong
import scala.jdk.CollectionConverters.*
final case class Timing(
    submitTimeMillis: Option[NullableLong] = None,
    startTimeMillis: Option[NullableLong] = None,
    finishTimeMillis: Option[NullableLong] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.Timing = {
    import Timing.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.Timing
      .builder()
      .optionallyWith(
        submitTimeMillis.map(value =>
          NullableLong.unwrap(value): java.lang.Long
        )
      )(_.submitTimeMillis)
      .optionallyWith(
        startTimeMillis.map(value => NullableLong.unwrap(value): java.lang.Long)
      )(_.startTimeMillis)
      .optionallyWith(
        finishTimeMillis.map(value =>
          NullableLong.unwrap(value): java.lang.Long
        )
      )(_.finishTimeMillis)
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.Timing.ReadOnly =
    zio.aws.elastictranscoder.model.Timing.wrap(buildAwsValue())
}
object Timing {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.Timing
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.Timing =
      zio.aws.elastictranscoder.model.Timing(
        submitTimeMillis.map(value => value),
        startTimeMillis.map(value => value),
        finishTimeMillis.map(value => value)
      )
    def submitTimeMillis: Option[NullableLong]
    def startTimeMillis: Option[NullableLong]
    def finishTimeMillis: Option[NullableLong]
    def getSubmitTimeMillis: ZIO[Any, AwsError, NullableLong] =
      AwsError.unwrapOptionField("submitTimeMillis", submitTimeMillis)
    def getStartTimeMillis: ZIO[Any, AwsError, NullableLong] =
      AwsError.unwrapOptionField("startTimeMillis", startTimeMillis)
    def getFinishTimeMillis: ZIO[Any, AwsError, NullableLong] =
      AwsError.unwrapOptionField("finishTimeMillis", finishTimeMillis)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.Timing
  ) extends zio.aws.elastictranscoder.model.Timing.ReadOnly {
    override val submitTimeMillis: Option[NullableLong] = scala
      .Option(impl.submitTimeMillis())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.NullableLong(value)
      )
    override val startTimeMillis: Option[NullableLong] = scala
      .Option(impl.startTimeMillis())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.NullableLong(value)
      )
    override val finishTimeMillis: Option[NullableLong] = scala
      .Option(impl.finishTimeMillis())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.NullableLong(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.Timing
  ): zio.aws.elastictranscoder.model.Timing.ReadOnly = new Wrapper(impl)
}
