package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elastictranscoder.model.primitives.MergePolicy
import scala.jdk.CollectionConverters.*
final case class JobAlbumArt(
    mergePolicy: Option[MergePolicy] = None,
    artwork: Option[Iterable[zio.aws.elastictranscoder.model.Artwork]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.JobAlbumArt = {
    import JobAlbumArt.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.JobAlbumArt
      .builder()
      .optionallyWith(
        mergePolicy.map(value => MergePolicy.unwrap(value): java.lang.String)
      )(_.mergePolicy)
      .optionallyWith(
        artwork.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.artwork)
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.JobAlbumArt.ReadOnly =
    zio.aws.elastictranscoder.model.JobAlbumArt.wrap(buildAwsValue())
}
object JobAlbumArt {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.JobAlbumArt
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.JobAlbumArt =
      zio.aws.elastictranscoder.model.JobAlbumArt(
        mergePolicy.map(value => value),
        artwork.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def mergePolicy: Option[MergePolicy]
    def artwork: Option[List[zio.aws.elastictranscoder.model.Artwork.ReadOnly]]
    def getMergePolicy: ZIO[Any, AwsError, MergePolicy] =
      AwsError.unwrapOptionField("mergePolicy", mergePolicy)
    def getArtwork: ZIO[Any, AwsError, List[
      zio.aws.elastictranscoder.model.Artwork.ReadOnly
    ]] = AwsError.unwrapOptionField("artwork", artwork)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.JobAlbumArt
  ) extends zio.aws.elastictranscoder.model.JobAlbumArt.ReadOnly {
    override val mergePolicy: Option[MergePolicy] = scala
      .Option(impl.mergePolicy())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.MergePolicy(value)
      )
    override val artwork
        : Option[List[zio.aws.elastictranscoder.model.Artwork.ReadOnly]] = scala
      .Option(impl.artwork())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elastictranscoder.model.Artwork.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.JobAlbumArt
  ): zio.aws.elastictranscoder.model.JobAlbumArt.ReadOnly = new Wrapper(impl)
}
