package zio.aws.elastictranscoder
import zio.aws.elastictranscoder.model.ReadPipelineResponse.ReadOnly
import zio.aws.elastictranscoder.model.{
  ListPresetsRequest,
  ReadPipelineRequest,
  CreatePresetRequest,
  CancelJobRequest,
  UpdatePipelineNotificationsRequest,
  ListPipelinesRequest,
  DeletePipelineRequest,
  UpdatePipelineStatusRequest,
  ReadPresetRequest,
  ListJobsByStatusRequest,
  CreateJobRequest,
  CreatePipelineRequest,
  UpdatePipelineRequest,
  ListJobsByPipelineRequest,
  ReadJobRequest,
  DeletePresetRequest
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.elastictranscoder.ElasticTranscoderAsyncClient
import zio.stream.ZStream
import zio.test.mock.{Proxy, Mock}
object ElasticTranscoderMock extends Mock[ElasticTranscoder] {
  object ListPresets
      extends Stream[
        ListPresetsRequest,
        AwsError,
        zio.aws.elastictranscoder.model.Preset.ReadOnly
      ]
  object ListPresetsPaginated
      extends Effect[
        ListPresetsRequest,
        AwsError,
        zio.aws.elastictranscoder.model.ListPresetsResponse.ReadOnly
      ]
  object ListJobsByPipeline
      extends Stream[
        ListJobsByPipelineRequest,
        AwsError,
        zio.aws.elastictranscoder.model.Job.ReadOnly
      ]
  object ListJobsByPipelinePaginated
      extends Effect[
        ListJobsByPipelineRequest,
        AwsError,
        zio.aws.elastictranscoder.model.ListJobsByPipelineResponse.ReadOnly
      ]
  object ListJobsByStatus
      extends Stream[
        ListJobsByStatusRequest,
        AwsError,
        zio.aws.elastictranscoder.model.Job.ReadOnly
      ]
  object ListJobsByStatusPaginated
      extends Effect[
        ListJobsByStatusRequest,
        AwsError,
        zio.aws.elastictranscoder.model.ListJobsByStatusResponse.ReadOnly
      ]
  object UpdatePipeline
      extends Effect[
        UpdatePipelineRequest,
        AwsError,
        zio.aws.elastictranscoder.model.UpdatePipelineResponse.ReadOnly
      ]
  object CreateJob
      extends Effect[
        CreateJobRequest,
        AwsError,
        zio.aws.elastictranscoder.model.CreateJobResponse.ReadOnly
      ]
  object CancelJob
      extends Effect[
        CancelJobRequest,
        AwsError,
        zio.aws.elastictranscoder.model.CancelJobResponse.ReadOnly
      ]
  object ListPipelines
      extends Stream[
        ListPipelinesRequest,
        AwsError,
        zio.aws.elastictranscoder.model.Pipeline.ReadOnly
      ]
  object ListPipelinesPaginated
      extends Effect[
        ListPipelinesRequest,
        AwsError,
        zio.aws.elastictranscoder.model.ListPipelinesResponse.ReadOnly
      ]
  object ReadPipeline extends Effect[ReadPipelineRequest, AwsError, ReadOnly]
  object DeletePreset
      extends Effect[
        DeletePresetRequest,
        AwsError,
        zio.aws.elastictranscoder.model.DeletePresetResponse.ReadOnly
      ]
  object UpdatePipelineStatus
      extends Effect[
        UpdatePipelineStatusRequest,
        AwsError,
        zio.aws.elastictranscoder.model.UpdatePipelineStatusResponse.ReadOnly
      ]
  object CreatePreset
      extends Effect[
        CreatePresetRequest,
        AwsError,
        zio.aws.elastictranscoder.model.CreatePresetResponse.ReadOnly
      ]
  object DeletePipeline
      extends Effect[
        DeletePipelineRequest,
        AwsError,
        zio.aws.elastictranscoder.model.DeletePipelineResponse.ReadOnly
      ]
  object ReadJob
      extends Effect[
        ReadJobRequest,
        AwsError,
        zio.aws.elastictranscoder.model.ReadJobResponse.ReadOnly
      ]
  object UpdatePipelineNotifications
      extends Effect[
        UpdatePipelineNotificationsRequest,
        AwsError,
        zio.aws.elastictranscoder.model.UpdatePipelineNotificationsResponse.ReadOnly
      ]
  object CreatePipeline
      extends Effect[
        CreatePipelineRequest,
        AwsError,
        zio.aws.elastictranscoder.model.CreatePipelineResponse.ReadOnly
      ]
  object ReadPreset
      extends Effect[
        ReadPresetRequest,
        AwsError,
        zio.aws.elastictranscoder.model.ReadPresetResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, ElasticTranscoder] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new ElasticTranscoder {
          val api: ElasticTranscoderAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : ElasticTranscoder = this
          def listPresets(request: ListPresetsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.elastictranscoder.model.Preset.ReadOnly
          ] = rts.unsafeRun(proxy(ListPresets, request))
          def listPresetsPaginated(request: ListPresetsRequest): IO[
            AwsError,
            zio.aws.elastictranscoder.model.ListPresetsResponse.ReadOnly
          ] = proxy(ListPresetsPaginated, request)
          def listJobsByPipeline(request: ListJobsByPipelineRequest): ZStream[
            Any,
            AwsError,
            zio.aws.elastictranscoder.model.Job.ReadOnly
          ] = rts.unsafeRun(proxy(ListJobsByPipeline, request))
          def listJobsByPipelinePaginated(
              request: ListJobsByPipelineRequest
          ): IO[
            AwsError,
            zio.aws.elastictranscoder.model.ListJobsByPipelineResponse.ReadOnly
          ] = proxy(ListJobsByPipelinePaginated, request)
          def listJobsByStatus(request: ListJobsByStatusRequest): ZStream[
            Any,
            AwsError,
            zio.aws.elastictranscoder.model.Job.ReadOnly
          ] = rts.unsafeRun(proxy(ListJobsByStatus, request))
          def listJobsByStatusPaginated(request: ListJobsByStatusRequest): IO[
            AwsError,
            zio.aws.elastictranscoder.model.ListJobsByStatusResponse.ReadOnly
          ] = proxy(ListJobsByStatusPaginated, request)
          def updatePipeline(request: UpdatePipelineRequest): IO[
            AwsError,
            zio.aws.elastictranscoder.model.UpdatePipelineResponse.ReadOnly
          ] = proxy(UpdatePipeline, request)
          def createJob(request: CreateJobRequest): IO[
            AwsError,
            zio.aws.elastictranscoder.model.CreateJobResponse.ReadOnly
          ] = proxy(CreateJob, request)
          def cancelJob(request: CancelJobRequest): IO[
            AwsError,
            zio.aws.elastictranscoder.model.CancelJobResponse.ReadOnly
          ] = proxy(CancelJob, request)
          def listPipelines(request: ListPipelinesRequest): ZStream[
            Any,
            AwsError,
            zio.aws.elastictranscoder.model.Pipeline.ReadOnly
          ] = rts.unsafeRun(proxy(ListPipelines, request))
          def listPipelinesPaginated(request: ListPipelinesRequest): IO[
            AwsError,
            zio.aws.elastictranscoder.model.ListPipelinesResponse.ReadOnly
          ] = proxy(ListPipelinesPaginated, request)
          def readPipeline(
              request: ReadPipelineRequest
          ): IO[AwsError, ReadOnly] = proxy(ReadPipeline, request)
          def deletePreset(request: DeletePresetRequest): IO[
            AwsError,
            zio.aws.elastictranscoder.model.DeletePresetResponse.ReadOnly
          ] = proxy(DeletePreset, request)
          def updatePipelineStatus(request: UpdatePipelineStatusRequest): IO[
            AwsError,
            zio.aws.elastictranscoder.model.UpdatePipelineStatusResponse.ReadOnly
          ] = proxy(UpdatePipelineStatus, request)
          def createPreset(request: CreatePresetRequest): IO[
            AwsError,
            zio.aws.elastictranscoder.model.CreatePresetResponse.ReadOnly
          ] = proxy(CreatePreset, request)
          def deletePipeline(request: DeletePipelineRequest): IO[
            AwsError,
            zio.aws.elastictranscoder.model.DeletePipelineResponse.ReadOnly
          ] = proxy(DeletePipeline, request)
          def readJob(request: ReadJobRequest): IO[
            AwsError,
            zio.aws.elastictranscoder.model.ReadJobResponse.ReadOnly
          ] = proxy(ReadJob, request)
          def updatePipelineNotifications(
              request: UpdatePipelineNotificationsRequest
          ): IO[
            AwsError,
            zio.aws.elastictranscoder.model.UpdatePipelineNotificationsResponse.ReadOnly
          ] = proxy(UpdatePipelineNotifications, request)
          def createPipeline(request: CreatePipelineRequest): IO[
            AwsError,
            zio.aws.elastictranscoder.model.CreatePipelineResponse.ReadOnly
          ] = proxy(CreatePipeline, request)
          def readPreset(request: ReadPresetRequest): IO[
            AwsError,
            zio.aws.elastictranscoder.model.ReadPresetResponse.ReadOnly
          ] = proxy(ReadPreset, request)
        }
      }
    }
    .toLayer
}
