package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elastictranscoder.model.primitives.SnsTopic
import scala.jdk.CollectionConverters._
final case class Notifications(
    progressing: Optional[SnsTopic] = Optional.Absent,
    completed: Optional[SnsTopic] = Optional.Absent,
    warning: Optional[SnsTopic] = Optional.Absent,
    error: Optional[SnsTopic] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.Notifications = {
    import Notifications.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.Notifications
      .builder()
      .optionallyWith(
        progressing.map(value => SnsTopic.unwrap(value): java.lang.String)
      )(_.progressing)
      .optionallyWith(
        completed.map(value => SnsTopic.unwrap(value): java.lang.String)
      )(_.completed)
      .optionallyWith(
        warning.map(value => SnsTopic.unwrap(value): java.lang.String)
      )(_.warning)
      .optionallyWith(
        error.map(value => SnsTopic.unwrap(value): java.lang.String)
      )(_.error)
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.Notifications.ReadOnly =
    zio.aws.elastictranscoder.model.Notifications.wrap(buildAwsValue())
}
object Notifications {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.Notifications
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.Notifications =
      zio.aws.elastictranscoder.model.Notifications(
        progressing.map(value => value),
        completed.map(value => value),
        warning.map(value => value),
        error.map(value => value)
      )
    def progressing: Optional[SnsTopic]
    def completed: Optional[SnsTopic]
    def warning: Optional[SnsTopic]
    def error: Optional[SnsTopic]
    def getProgressing: ZIO[Any, AwsError, SnsTopic] =
      AwsError.unwrapOptionField("progressing", progressing)
    def getCompleted: ZIO[Any, AwsError, SnsTopic] =
      AwsError.unwrapOptionField("completed", completed)
    def getWarning: ZIO[Any, AwsError, SnsTopic] =
      AwsError.unwrapOptionField("warning", warning)
    def getError: ZIO[Any, AwsError, SnsTopic] =
      AwsError.unwrapOptionField("error", error)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.Notifications
  ) extends zio.aws.elastictranscoder.model.Notifications.ReadOnly {
    override val progressing: Optional[SnsTopic] = zio.aws.core.internal
      .optionalFromNullable(impl.progressing())
      .map(value => zio.aws.elastictranscoder.model.primitives.SnsTopic(value))
    override val completed: Optional[SnsTopic] = zio.aws.core.internal
      .optionalFromNullable(impl.completed())
      .map(value => zio.aws.elastictranscoder.model.primitives.SnsTopic(value))
    override val warning: Optional[SnsTopic] = zio.aws.core.internal
      .optionalFromNullable(impl.warning())
      .map(value => zio.aws.elastictranscoder.model.primitives.SnsTopic(value))
    override val error: Optional[SnsTopic] = zio.aws.core.internal
      .optionalFromNullable(impl.error())
      .map(value => zio.aws.elastictranscoder.model.primitives.SnsTopic(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.Notifications
  ): zio.aws.elastictranscoder.model.Notifications.ReadOnly = new Wrapper(impl)
}
