package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elastictranscoder.model.primitives.CaptionMergePolicy
import scala.jdk.CollectionConverters._
final case class InputCaptions(
    mergePolicy: Optional[CaptionMergePolicy] = Optional.Absent,
    captionSources: Optional[
      Iterable[zio.aws.elastictranscoder.model.CaptionSource]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.InputCaptions = {
    import InputCaptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.InputCaptions
      .builder()
      .optionallyWith(
        mergePolicy.map(value =>
          CaptionMergePolicy.unwrap(value): java.lang.String
        )
      )(_.mergePolicy)
      .optionallyWith(
        captionSources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.captionSources)
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.InputCaptions.ReadOnly =
    zio.aws.elastictranscoder.model.InputCaptions.wrap(buildAwsValue())
}
object InputCaptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.InputCaptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.InputCaptions =
      zio.aws.elastictranscoder.model.InputCaptions(
        mergePolicy.map(value => value),
        captionSources.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def mergePolicy: Optional[CaptionMergePolicy]
    def captionSources
        : Optional[List[zio.aws.elastictranscoder.model.CaptionSource.ReadOnly]]
    def getMergePolicy: ZIO[Any, AwsError, CaptionMergePolicy] =
      AwsError.unwrapOptionField("mergePolicy", mergePolicy)
    def getCaptionSources: ZIO[Any, AwsError, List[
      zio.aws.elastictranscoder.model.CaptionSource.ReadOnly
    ]] = AwsError.unwrapOptionField("captionSources", captionSources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.InputCaptions
  ) extends zio.aws.elastictranscoder.model.InputCaptions.ReadOnly {
    override val mergePolicy: Optional[CaptionMergePolicy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mergePolicy())
        .map(value =>
          zio.aws.elastictranscoder.model.primitives.CaptionMergePolicy(value)
        )
    override val captionSources: Optional[
      List[zio.aws.elastictranscoder.model.CaptionSource.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.captionSources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elastictranscoder.model.CaptionSource.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.InputCaptions
  ): zio.aws.elastictranscoder.model.InputCaptions.ReadOnly = new Wrapper(impl)
}
