package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elastictranscoder.model.primitives.{
  DigitsOrAuto,
  ThumbnailResolution,
  AspectRatio,
  JpgOrPng,
  PaddingPolicy,
  Digits,
  SizingPolicy
}
import scala.jdk.CollectionConverters._
final case class Thumbnails(
    format: Optional[JpgOrPng] = Optional.Absent,
    interval: Optional[Digits] = Optional.Absent,
    resolution: Optional[ThumbnailResolution] = Optional.Absent,
    aspectRatio: Optional[AspectRatio] = Optional.Absent,
    maxWidth: Optional[DigitsOrAuto] = Optional.Absent,
    maxHeight: Optional[DigitsOrAuto] = Optional.Absent,
    sizingPolicy: Optional[SizingPolicy] = Optional.Absent,
    paddingPolicy: Optional[PaddingPolicy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.Thumbnails = {
    import Thumbnails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.Thumbnails
      .builder()
      .optionallyWith(
        format.map(value => JpgOrPng.unwrap(value): java.lang.String)
      )(_.format)
      .optionallyWith(
        interval.map(value => Digits.unwrap(value): java.lang.String)
      )(_.interval)
      .optionallyWith(
        resolution.map(value =>
          ThumbnailResolution.unwrap(value): java.lang.String
        )
      )(_.resolution)
      .optionallyWith(
        aspectRatio.map(value => AspectRatio.unwrap(value): java.lang.String)
      )(_.aspectRatio)
      .optionallyWith(
        maxWidth.map(value => DigitsOrAuto.unwrap(value): java.lang.String)
      )(_.maxWidth)
      .optionallyWith(
        maxHeight.map(value => DigitsOrAuto.unwrap(value): java.lang.String)
      )(_.maxHeight)
      .optionallyWith(
        sizingPolicy.map(value => SizingPolicy.unwrap(value): java.lang.String)
      )(_.sizingPolicy)
      .optionallyWith(
        paddingPolicy.map(value =>
          PaddingPolicy.unwrap(value): java.lang.String
        )
      )(_.paddingPolicy)
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.Thumbnails.ReadOnly =
    zio.aws.elastictranscoder.model.Thumbnails.wrap(buildAwsValue())
}
object Thumbnails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.Thumbnails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.Thumbnails =
      zio.aws.elastictranscoder.model.Thumbnails(
        format.map(value => value),
        interval.map(value => value),
        resolution.map(value => value),
        aspectRatio.map(value => value),
        maxWidth.map(value => value),
        maxHeight.map(value => value),
        sizingPolicy.map(value => value),
        paddingPolicy.map(value => value)
      )
    def format: Optional[JpgOrPng]
    def interval: Optional[Digits]
    def resolution: Optional[ThumbnailResolution]
    def aspectRatio: Optional[AspectRatio]
    def maxWidth: Optional[DigitsOrAuto]
    def maxHeight: Optional[DigitsOrAuto]
    def sizingPolicy: Optional[SizingPolicy]
    def paddingPolicy: Optional[PaddingPolicy]
    def getFormat: ZIO[Any, AwsError, JpgOrPng] =
      AwsError.unwrapOptionField("format", format)
    def getInterval: ZIO[Any, AwsError, Digits] =
      AwsError.unwrapOptionField("interval", interval)
    def getResolution: ZIO[Any, AwsError, ThumbnailResolution] =
      AwsError.unwrapOptionField("resolution", resolution)
    def getAspectRatio: ZIO[Any, AwsError, AspectRatio] =
      AwsError.unwrapOptionField("aspectRatio", aspectRatio)
    def getMaxWidth: ZIO[Any, AwsError, DigitsOrAuto] =
      AwsError.unwrapOptionField("maxWidth", maxWidth)
    def getMaxHeight: ZIO[Any, AwsError, DigitsOrAuto] =
      AwsError.unwrapOptionField("maxHeight", maxHeight)
    def getSizingPolicy: ZIO[Any, AwsError, SizingPolicy] =
      AwsError.unwrapOptionField("sizingPolicy", sizingPolicy)
    def getPaddingPolicy: ZIO[Any, AwsError, PaddingPolicy] =
      AwsError.unwrapOptionField("paddingPolicy", paddingPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.Thumbnails
  ) extends zio.aws.elastictranscoder.model.Thumbnails.ReadOnly {
    override val format: Optional[JpgOrPng] = zio.aws.core.internal
      .optionalFromNullable(impl.format())
      .map(value => zio.aws.elastictranscoder.model.primitives.JpgOrPng(value))
    override val interval: Optional[Digits] = zio.aws.core.internal
      .optionalFromNullable(impl.interval())
      .map(value => zio.aws.elastictranscoder.model.primitives.Digits(value))
    override val resolution: Optional[ThumbnailResolution] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resolution())
        .map(value =>
          zio.aws.elastictranscoder.model.primitives.ThumbnailResolution(value)
        )
    override val aspectRatio: Optional[AspectRatio] = zio.aws.core.internal
      .optionalFromNullable(impl.aspectRatio())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.AspectRatio(value)
      )
    override val maxWidth: Optional[DigitsOrAuto] = zio.aws.core.internal
      .optionalFromNullable(impl.maxWidth())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.DigitsOrAuto(value)
      )
    override val maxHeight: Optional[DigitsOrAuto] = zio.aws.core.internal
      .optionalFromNullable(impl.maxHeight())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.DigitsOrAuto(value)
      )
    override val sizingPolicy: Optional[SizingPolicy] = zio.aws.core.internal
      .optionalFromNullable(impl.sizingPolicy())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.SizingPolicy(value)
      )
    override val paddingPolicy: Optional[PaddingPolicy] = zio.aws.core.internal
      .optionalFromNullable(impl.paddingPolicy())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.PaddingPolicy(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.Thumbnails
  ): zio.aws.elastictranscoder.model.Thumbnails.ReadOnly = new Wrapper(impl)
}
