package zio.aws.elastictranscoder
import zio.prelude.Subtype
import zio.aws.elastictranscoder.model.primitives.{
  Key,
  CodecOption,
  AccessControl
}
import zio.aws.elastictranscoder.model.primitives.CaptionFormatPattern.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AccessControl extends Subtype[String]
    type AccessControl =
      zio.aws.elastictranscoder.model.primitives.AccessControl.Type
    object Ascending extends Subtype[String]
    type Ascending = zio.aws.elastictranscoder.model.primitives.Ascending.Type
    object AspectRatio extends Subtype[String]
    type AspectRatio =
      zio.aws.elastictranscoder.model.primitives.AspectRatio.Type
    object AudioBitDepth extends Subtype[String]
    type AudioBitDepth =
      zio.aws.elastictranscoder.model.primitives.AudioBitDepth.Type
    object AudioBitOrder extends Subtype[String]
    type AudioBitOrder =
      zio.aws.elastictranscoder.model.primitives.AudioBitOrder.Type
    object AudioBitRate extends Subtype[String]
    type AudioBitRate =
      zio.aws.elastictranscoder.model.primitives.AudioBitRate.Type
    object AudioChannels extends Subtype[String]
    type AudioChannels =
      zio.aws.elastictranscoder.model.primitives.AudioChannels.Type
    object AudioCodec extends Subtype[String]
    type AudioCodec = zio.aws.elastictranscoder.model.primitives.AudioCodec.Type
    object AudioCodecProfile extends Subtype[String]
    type AudioCodecProfile =
      zio.aws.elastictranscoder.model.primitives.AudioCodecProfile.Type
    object AudioPackingMode extends Subtype[String]
    type AudioPackingMode =
      zio.aws.elastictranscoder.model.primitives.AudioPackingMode.Type
    object AudioSampleRate extends Subtype[String]
    type AudioSampleRate =
      zio.aws.elastictranscoder.model.primitives.AudioSampleRate.Type
    object AudioSigned extends Subtype[String]
    type AudioSigned =
      zio.aws.elastictranscoder.model.primitives.AudioSigned.Type
    object Base64EncodedString extends Subtype[String]
    type Base64EncodedString =
      zio.aws.elastictranscoder.model.primitives.Base64EncodedString.Type
    object BucketName extends Subtype[String]
    type BucketName = zio.aws.elastictranscoder.model.primitives.BucketName.Type
    object CaptionFormatFormat extends Subtype[String]
    type CaptionFormatFormat =
      zio.aws.elastictranscoder.model.primitives.CaptionFormatFormat.Type
    object CaptionFormatPattern extends Subtype[String]
    type CaptionFormatPattern =
      zio.aws.elastictranscoder.model.primitives.CaptionFormatPattern.Type
    object CaptionMergePolicy extends Subtype[String]
    type CaptionMergePolicy =
      zio.aws.elastictranscoder.model.primitives.CaptionMergePolicy.Type
    object CodecOption extends Subtype[String]
    type CodecOption =
      zio.aws.elastictranscoder.model.primitives.CodecOption.Type
    object Description extends Subtype[String]
    type Description =
      zio.aws.elastictranscoder.model.primitives.Description.Type
    object Digits extends Subtype[String]
    type Digits = zio.aws.elastictranscoder.model.primitives.Digits.Type
    object DigitsOrAuto extends Subtype[String]
    type DigitsOrAuto =
      zio.aws.elastictranscoder.model.primitives.DigitsOrAuto.Type
    object EncryptionMode extends Subtype[String]
    type EncryptionMode =
      zio.aws.elastictranscoder.model.primitives.EncryptionMode.Type
    object Filename extends Subtype[String]
    type Filename = zio.aws.elastictranscoder.model.primitives.Filename.Type
    object FixedGOP extends Subtype[String]
    type FixedGOP = zio.aws.elastictranscoder.model.primitives.FixedGOP.Type
    object FloatString extends Subtype[String]
    type FloatString =
      zio.aws.elastictranscoder.model.primitives.FloatString.Type
    object FrameRate extends Subtype[String]
    type FrameRate = zio.aws.elastictranscoder.model.primitives.FrameRate.Type
    object Grantee extends Subtype[String]
    type Grantee = zio.aws.elastictranscoder.model.primitives.Grantee.Type
    object GranteeType extends Subtype[String]
    type GranteeType =
      zio.aws.elastictranscoder.model.primitives.GranteeType.Type
    object HlsContentProtectionMethod extends Subtype[String]
    type HlsContentProtectionMethod =
      zio.aws.elastictranscoder.model.primitives.HlsContentProtectionMethod.Type
    object HorizontalAlign extends Subtype[String]
    type HorizontalAlign =
      zio.aws.elastictranscoder.model.primitives.HorizontalAlign.Type
    object Id extends Subtype[String]
    type Id = zio.aws.elastictranscoder.model.primitives.Id.Type
    object Interlaced extends Subtype[String]
    type Interlaced = zio.aws.elastictranscoder.model.primitives.Interlaced.Type
    object JobContainer extends Subtype[String]
    type JobContainer =
      zio.aws.elastictranscoder.model.primitives.JobContainer.Type
    object JobStatus extends Subtype[String]
    type JobStatus = zio.aws.elastictranscoder.model.primitives.JobStatus.Type
    object JpgOrPng extends Subtype[String]
    type JpgOrPng = zio.aws.elastictranscoder.model.primitives.JpgOrPng.Type
    object Key extends Subtype[String]
    type Key = zio.aws.elastictranscoder.model.primitives.Key.Type
    object KeyArn extends Subtype[String]
    type KeyArn = zio.aws.elastictranscoder.model.primitives.KeyArn.Type
    object KeyIdGuid extends Subtype[String]
    type KeyIdGuid = zio.aws.elastictranscoder.model.primitives.KeyIdGuid.Type
    object KeyStoragePolicy extends Subtype[String]
    type KeyStoragePolicy =
      zio.aws.elastictranscoder.model.primitives.KeyStoragePolicy.Type
    object KeyframesMaxDist extends Subtype[String]
    type KeyframesMaxDist =
      zio.aws.elastictranscoder.model.primitives.KeyframesMaxDist.Type
    object LongKey extends Subtype[String]
    type LongKey = zio.aws.elastictranscoder.model.primitives.LongKey.Type
    object MaxFrameRate extends Subtype[String]
    type MaxFrameRate =
      zio.aws.elastictranscoder.model.primitives.MaxFrameRate.Type
    object MergePolicy extends Subtype[String]
    type MergePolicy =
      zio.aws.elastictranscoder.model.primitives.MergePolicy.Type
    object Name extends Subtype[String]
    type Name = zio.aws.elastictranscoder.model.primitives.Name.Type
    object NonEmptyBase64EncodedString extends Subtype[String]
    type NonEmptyBase64EncodedString =
      zio.aws.elastictranscoder.model.primitives.NonEmptyBase64EncodedString.Type
    type NullableInteger = Int
    type NullableLong = Long
    object OneTo512String extends Subtype[String]
    type OneTo512String =
      zio.aws.elastictranscoder.model.primitives.OneTo512String.Type
    object Opacity extends Subtype[String]
    type Opacity = zio.aws.elastictranscoder.model.primitives.Opacity.Type
    object PaddingPolicy extends Subtype[String]
    type PaddingPolicy =
      zio.aws.elastictranscoder.model.primitives.PaddingPolicy.Type
    object PipelineStatus extends Subtype[String]
    type PipelineStatus =
      zio.aws.elastictranscoder.model.primitives.PipelineStatus.Type
    object PixelsOrPercent extends Subtype[String]
    type PixelsOrPercent =
      zio.aws.elastictranscoder.model.primitives.PixelsOrPercent.Type
    object PlayReadyDrmFormatString extends Subtype[String]
    type PlayReadyDrmFormatString =
      zio.aws.elastictranscoder.model.primitives.PlayReadyDrmFormatString.Type
    object PlaylistFormat extends Subtype[String]
    type PlaylistFormat =
      zio.aws.elastictranscoder.model.primitives.PlaylistFormat.Type
    object PresetContainer extends Subtype[String]
    type PresetContainer =
      zio.aws.elastictranscoder.model.primitives.PresetContainer.Type
    object PresetType extends Subtype[String]
    type PresetType = zio.aws.elastictranscoder.model.primitives.PresetType.Type
    object PresetWatermarkId extends Subtype[String]
    type PresetWatermarkId =
      zio.aws.elastictranscoder.model.primitives.PresetWatermarkId.Type
    object Resolution extends Subtype[String]
    type Resolution = zio.aws.elastictranscoder.model.primitives.Resolution.Type
    object Role extends Subtype[String]
    type Role = zio.aws.elastictranscoder.model.primitives.Role.Type
    object Rotate extends Subtype[String]
    type Rotate = zio.aws.elastictranscoder.model.primitives.Rotate.Type
    object SizingPolicy extends Subtype[String]
    type SizingPolicy =
      zio.aws.elastictranscoder.model.primitives.SizingPolicy.Type
    object SnsTopic extends Subtype[String]
    type SnsTopic = zio.aws.elastictranscoder.model.primitives.SnsTopic.Type
    object StorageClass extends Subtype[String]
    type StorageClass =
      zio.aws.elastictranscoder.model.primitives.StorageClass.Type
    object Target extends Subtype[String]
    type Target = zio.aws.elastictranscoder.model.primitives.Target.Type
    object ThumbnailPattern extends Subtype[String]
    type ThumbnailPattern =
      zio.aws.elastictranscoder.model.primitives.ThumbnailPattern.Type
    object ThumbnailResolution extends Subtype[String]
    type ThumbnailResolution =
      zio.aws.elastictranscoder.model.primitives.ThumbnailResolution.Type
    object Time extends Subtype[String]
    type Time = zio.aws.elastictranscoder.model.primitives.Time.Type
    object TimeOffset extends Subtype[String]
    type TimeOffset = zio.aws.elastictranscoder.model.primitives.TimeOffset.Type
    object VerticalAlign extends Subtype[String]
    type VerticalAlign =
      zio.aws.elastictranscoder.model.primitives.VerticalAlign.Type
    object VideoBitRate extends Subtype[String]
    type VideoBitRate =
      zio.aws.elastictranscoder.model.primitives.VideoBitRate.Type
    object VideoCodec extends Subtype[String]
    type VideoCodec = zio.aws.elastictranscoder.model.primitives.VideoCodec.Type
    object WatermarkKey extends Subtype[String]
    type WatermarkKey =
      zio.aws.elastictranscoder.model.primitives.WatermarkKey.Type
    object WatermarkSizingPolicy extends Subtype[String]
    type WatermarkSizingPolicy =
      zio.aws.elastictranscoder.model.primitives.WatermarkSizingPolicy.Type
    object ZeroTo255String extends Subtype[String]
    type ZeroTo255String =
      zio.aws.elastictranscoder.model.primitives.ZeroTo255String.Type
    object ZeroTo512String extends Subtype[String]
    type ZeroTo512String =
      zio.aws.elastictranscoder.model.primitives.ZeroTo512String.Type
  }
  type AccessControls = List[AccessControl]
  type Artworks = List[zio.aws.elastictranscoder.model.Artwork]
  type CaptionFormats = List[zio.aws.elastictranscoder.model.CaptionFormat]
  type CaptionSources = List[zio.aws.elastictranscoder.model.CaptionSource]
  type CodecOptions = Map[CodecOption, CodecOption]
  type Composition = List[zio.aws.elastictranscoder.model.Clip]
  type CreateJobOutputs = List[zio.aws.elastictranscoder.model.CreateJobOutput]
  type CreateJobPlaylists =
    List[zio.aws.elastictranscoder.model.CreateJobPlaylist]
  type JobInputs = List[zio.aws.elastictranscoder.model.JobInput]
  type JobOutputs = List[zio.aws.elastictranscoder.model.JobOutput]
  type JobWatermarks = List[zio.aws.elastictranscoder.model.JobWatermark]
  type Jobs = List[zio.aws.elastictranscoder.model.Job]
  type OutputKeys = List[Key]
  type Permissions = List[zio.aws.elastictranscoder.model.Permission]
  type Pipelines = List[zio.aws.elastictranscoder.model.Pipeline]
  type Playlists = List[zio.aws.elastictranscoder.model.Playlist]
  type PresetWatermarks = List[zio.aws.elastictranscoder.model.PresetWatermark]
  type Presets = List[zio.aws.elastictranscoder.model.Preset]
  type UserMetadata = Map[String, String]
  type Warnings = List[zio.aws.elastictranscoder.model.Warning]
}
