package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elastictranscoder.model.primitives.{
  PresetContainer,
  Description,
  Name
}
import scala.jdk.CollectionConverters._
final case class CreatePresetRequest(
    name: Name,
    description: Optional[Description] = Optional.Absent,
    container: PresetContainer,
    video: Optional[zio.aws.elastictranscoder.model.VideoParameters] =
      Optional.Absent,
    audio: Optional[zio.aws.elastictranscoder.model.AudioParameters] =
      Optional.Absent,
    thumbnails: Optional[zio.aws.elastictranscoder.model.Thumbnails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.CreatePresetRequest = {
    import CreatePresetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.CreatePresetRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .container(PresetContainer.unwrap(container): java.lang.String)
      .optionallyWith(video.map(value => value.buildAwsValue()))(_.video)
      .optionallyWith(audio.map(value => value.buildAwsValue()))(_.audio)
      .optionallyWith(thumbnails.map(value => value.buildAwsValue()))(
        _.thumbnails
      )
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.CreatePresetRequest.ReadOnly =
    zio.aws.elastictranscoder.model.CreatePresetRequest.wrap(buildAwsValue())
}
object CreatePresetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.CreatePresetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.CreatePresetRequest =
      zio.aws.elastictranscoder.model.CreatePresetRequest(
        name,
        description.map(value => value),
        container,
        video.map(value => value.asEditable),
        audio.map(value => value.asEditable),
        thumbnails.map(value => value.asEditable)
      )
    def name: Name
    def description: Optional[Description]
    def container: PresetContainer
    def video
        : Optional[zio.aws.elastictranscoder.model.VideoParameters.ReadOnly]
    def audio
        : Optional[zio.aws.elastictranscoder.model.AudioParameters.ReadOnly]
    def thumbnails
        : Optional[zio.aws.elastictranscoder.model.Thumbnails.ReadOnly]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getContainer: ZIO[Any, Nothing, PresetContainer] =
      ZIO.succeed(container)
    def getVideo: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.VideoParameters.ReadOnly
    ] = AwsError.unwrapOptionField("video", video)
    def getAudio: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.AudioParameters.ReadOnly
    ] = AwsError.unwrapOptionField("audio", audio)
    def getThumbnails: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.Thumbnails.ReadOnly
    ] = AwsError.unwrapOptionField("thumbnails", thumbnails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.CreatePresetRequest
  ) extends zio.aws.elastictranscoder.model.CreatePresetRequest.ReadOnly {
    override val name: Name =
      zio.aws.elastictranscoder.model.primitives.Name(impl.name())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.Description(value)
      )
    override val container: PresetContainer =
      zio.aws.elastictranscoder.model.primitives
        .PresetContainer(impl.container())
    override val video
        : Optional[zio.aws.elastictranscoder.model.VideoParameters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.video())
        .map(value =>
          zio.aws.elastictranscoder.model.VideoParameters.wrap(value)
        )
    override val audio
        : Optional[zio.aws.elastictranscoder.model.AudioParameters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.audio())
        .map(value =>
          zio.aws.elastictranscoder.model.AudioParameters.wrap(value)
        )
    override val thumbnails
        : Optional[zio.aws.elastictranscoder.model.Thumbnails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.thumbnails())
        .map(value => zio.aws.elastictranscoder.model.Thumbnails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.CreatePresetRequest
  ): zio.aws.elastictranscoder.model.CreatePresetRequest.ReadOnly = new Wrapper(
    impl
  )
}
