package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elastictranscoder.model.primitives.Id
import scala.jdk.CollectionConverters._
final case class ListJobsByStatusResponse(
    jobs: Optional[Iterable[zio.aws.elastictranscoder.model.Job]] =
      Optional.Absent,
    nextPageToken: Optional[Id] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.ListJobsByStatusResponse = {
    import ListJobsByStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.ListJobsByStatusResponse
      .builder()
      .optionallyWith(
        jobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.jobs)
      .optionallyWith(
        nextPageToken.map(value => Id.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elastictranscoder.model.ListJobsByStatusResponse.ReadOnly =
    zio.aws.elastictranscoder.model.ListJobsByStatusResponse
      .wrap(buildAwsValue())
}
object ListJobsByStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.ListJobsByStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.ListJobsByStatusResponse =
      zio.aws.elastictranscoder.model.ListJobsByStatusResponse(
        jobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def jobs: Optional[List[zio.aws.elastictranscoder.model.Job.ReadOnly]]
    def nextPageToken: Optional[Id]
    def getJobs: ZIO[Any, AwsError, List[
      zio.aws.elastictranscoder.model.Job.ReadOnly
    ]] = AwsError.unwrapOptionField("jobs", jobs)
    def getNextPageToken: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.ListJobsByStatusResponse
  ) extends zio.aws.elastictranscoder.model.ListJobsByStatusResponse.ReadOnly {
    override val jobs
        : Optional[List[zio.aws.elastictranscoder.model.Job.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elastictranscoder.model.Job.wrap(item)
          }.toList
        )
    override val nextPageToken: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.nextPageToken())
      .map(value => zio.aws.elastictranscoder.model.primitives.Id(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.ListJobsByStatusResponse
  ): zio.aws.elastictranscoder.model.ListJobsByStatusResponse.ReadOnly =
    new Wrapper(impl)
}
