package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elastictranscoder.model.primitives.{
  DigitsOrAuto,
  JpgOrPng,
  WatermarkKey,
  PaddingPolicy,
  SizingPolicy
}
import scala.jdk.CollectionConverters._
final case class Artwork(
    inputKey: Optional[WatermarkKey] = Optional.Absent,
    maxWidth: Optional[DigitsOrAuto] = Optional.Absent,
    maxHeight: Optional[DigitsOrAuto] = Optional.Absent,
    sizingPolicy: Optional[SizingPolicy] = Optional.Absent,
    paddingPolicy: Optional[PaddingPolicy] = Optional.Absent,
    albumArtFormat: Optional[JpgOrPng] = Optional.Absent,
    encryption: Optional[zio.aws.elastictranscoder.model.Encryption] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.Artwork = {
    import Artwork.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.Artwork
      .builder()
      .optionallyWith(
        inputKey.map(value => WatermarkKey.unwrap(value): java.lang.String)
      )(_.inputKey)
      .optionallyWith(
        maxWidth.map(value => DigitsOrAuto.unwrap(value): java.lang.String)
      )(_.maxWidth)
      .optionallyWith(
        maxHeight.map(value => DigitsOrAuto.unwrap(value): java.lang.String)
      )(_.maxHeight)
      .optionallyWith(
        sizingPolicy.map(value => SizingPolicy.unwrap(value): java.lang.String)
      )(_.sizingPolicy)
      .optionallyWith(
        paddingPolicy.map(value =>
          PaddingPolicy.unwrap(value): java.lang.String
        )
      )(_.paddingPolicy)
      .optionallyWith(
        albumArtFormat.map(value => JpgOrPng.unwrap(value): java.lang.String)
      )(_.albumArtFormat)
      .optionallyWith(encryption.map(value => value.buildAwsValue()))(
        _.encryption
      )
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.Artwork.ReadOnly =
    zio.aws.elastictranscoder.model.Artwork.wrap(buildAwsValue())
}
object Artwork {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.Artwork
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.Artwork =
      zio.aws.elastictranscoder.model.Artwork(
        inputKey.map(value => value),
        maxWidth.map(value => value),
        maxHeight.map(value => value),
        sizingPolicy.map(value => value),
        paddingPolicy.map(value => value),
        albumArtFormat.map(value => value),
        encryption.map(value => value.asEditable)
      )
    def inputKey: Optional[WatermarkKey]
    def maxWidth: Optional[DigitsOrAuto]
    def maxHeight: Optional[DigitsOrAuto]
    def sizingPolicy: Optional[SizingPolicy]
    def paddingPolicy: Optional[PaddingPolicy]
    def albumArtFormat: Optional[JpgOrPng]
    def encryption
        : Optional[zio.aws.elastictranscoder.model.Encryption.ReadOnly]
    def getInputKey: ZIO[Any, AwsError, WatermarkKey] =
      AwsError.unwrapOptionField("inputKey", inputKey)
    def getMaxWidth: ZIO[Any, AwsError, DigitsOrAuto] =
      AwsError.unwrapOptionField("maxWidth", maxWidth)
    def getMaxHeight: ZIO[Any, AwsError, DigitsOrAuto] =
      AwsError.unwrapOptionField("maxHeight", maxHeight)
    def getSizingPolicy: ZIO[Any, AwsError, SizingPolicy] =
      AwsError.unwrapOptionField("sizingPolicy", sizingPolicy)
    def getPaddingPolicy: ZIO[Any, AwsError, PaddingPolicy] =
      AwsError.unwrapOptionField("paddingPolicy", paddingPolicy)
    def getAlbumArtFormat: ZIO[Any, AwsError, JpgOrPng] =
      AwsError.unwrapOptionField("albumArtFormat", albumArtFormat)
    def getEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.Encryption.ReadOnly
    ] = AwsError.unwrapOptionField("encryption", encryption)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.Artwork
  ) extends zio.aws.elastictranscoder.model.Artwork.ReadOnly {
    override val inputKey: Optional[WatermarkKey] = zio.aws.core.internal
      .optionalFromNullable(impl.inputKey())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.WatermarkKey(value)
      )
    override val maxWidth: Optional[DigitsOrAuto] = zio.aws.core.internal
      .optionalFromNullable(impl.maxWidth())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.DigitsOrAuto(value)
      )
    override val maxHeight: Optional[DigitsOrAuto] = zio.aws.core.internal
      .optionalFromNullable(impl.maxHeight())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.DigitsOrAuto(value)
      )
    override val sizingPolicy: Optional[SizingPolicy] = zio.aws.core.internal
      .optionalFromNullable(impl.sizingPolicy())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.SizingPolicy(value)
      )
    override val paddingPolicy: Optional[PaddingPolicy] = zio.aws.core.internal
      .optionalFromNullable(impl.paddingPolicy())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.PaddingPolicy(value)
      )
    override val albumArtFormat: Optional[JpgOrPng] = zio.aws.core.internal
      .optionalFromNullable(impl.albumArtFormat())
      .map(value => zio.aws.elastictranscoder.model.primitives.JpgOrPng(value))
    override val encryption
        : Optional[zio.aws.elastictranscoder.model.Encryption.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryption())
        .map(value => zio.aws.elastictranscoder.model.Encryption.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.Artwork
  ): zio.aws.elastictranscoder.model.Artwork.ReadOnly = new Wrapper(impl)
}
