package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreatePipelineResponse(
    pipeline: Optional[zio.aws.elastictranscoder.model.Pipeline] =
      Optional.Absent,
    warnings: Optional[Iterable[zio.aws.elastictranscoder.model.Warning]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.CreatePipelineResponse = {
    import CreatePipelineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.CreatePipelineResponse
      .builder()
      .optionallyWith(pipeline.map(value => value.buildAwsValue()))(_.pipeline)
      .optionallyWith(
        warnings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.warnings)
      .build()
  }
  def asReadOnly
      : zio.aws.elastictranscoder.model.CreatePipelineResponse.ReadOnly =
    zio.aws.elastictranscoder.model.CreatePipelineResponse.wrap(buildAwsValue())
}
object CreatePipelineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.CreatePipelineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.CreatePipelineResponse =
      zio.aws.elastictranscoder.model.CreatePipelineResponse(
        pipeline.map(value => value.asEditable),
        warnings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def pipeline: Optional[zio.aws.elastictranscoder.model.Pipeline.ReadOnly]
    def warnings
        : Optional[List[zio.aws.elastictranscoder.model.Warning.ReadOnly]]
    def getPipeline: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.Pipeline.ReadOnly
    ] = AwsError.unwrapOptionField("pipeline", pipeline)
    def getWarnings: ZIO[Any, AwsError, List[
      zio.aws.elastictranscoder.model.Warning.ReadOnly
    ]] = AwsError.unwrapOptionField("warnings", warnings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.CreatePipelineResponse
  ) extends zio.aws.elastictranscoder.model.CreatePipelineResponse.ReadOnly {
    override val pipeline
        : Optional[zio.aws.elastictranscoder.model.Pipeline.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipeline())
        .map(value => zio.aws.elastictranscoder.model.Pipeline.wrap(value))
    override val warnings
        : Optional[List[zio.aws.elastictranscoder.model.Warning.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.warnings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elastictranscoder.model.Warning.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.CreatePipelineResponse
  ): zio.aws.elastictranscoder.model.CreatePipelineResponse.ReadOnly =
    new Wrapper(impl)
}
