package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elastictranscoder.model.primitives.{
  WatermarkKey,
  PresetWatermarkId
}
import scala.jdk.CollectionConverters._
final case class JobWatermark(
    presetWatermarkId: Optional[PresetWatermarkId] = Optional.Absent,
    inputKey: Optional[WatermarkKey] = Optional.Absent,
    encryption: Optional[zio.aws.elastictranscoder.model.Encryption] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.JobWatermark = {
    import JobWatermark.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.JobWatermark
      .builder()
      .optionallyWith(
        presetWatermarkId.map(value =>
          PresetWatermarkId.unwrap(value): java.lang.String
        )
      )(_.presetWatermarkId)
      .optionallyWith(
        inputKey.map(value => WatermarkKey.unwrap(value): java.lang.String)
      )(_.inputKey)
      .optionallyWith(encryption.map(value => value.buildAwsValue()))(
        _.encryption
      )
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.JobWatermark.ReadOnly =
    zio.aws.elastictranscoder.model.JobWatermark.wrap(buildAwsValue())
}
object JobWatermark {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.JobWatermark
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.JobWatermark =
      zio.aws.elastictranscoder.model.JobWatermark(
        presetWatermarkId.map(value => value),
        inputKey.map(value => value),
        encryption.map(value => value.asEditable)
      )
    def presetWatermarkId: Optional[PresetWatermarkId]
    def inputKey: Optional[WatermarkKey]
    def encryption
        : Optional[zio.aws.elastictranscoder.model.Encryption.ReadOnly]
    def getPresetWatermarkId: ZIO[Any, AwsError, PresetWatermarkId] =
      AwsError.unwrapOptionField("presetWatermarkId", presetWatermarkId)
    def getInputKey: ZIO[Any, AwsError, WatermarkKey] =
      AwsError.unwrapOptionField("inputKey", inputKey)
    def getEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.Encryption.ReadOnly
    ] = AwsError.unwrapOptionField("encryption", encryption)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.JobWatermark
  ) extends zio.aws.elastictranscoder.model.JobWatermark.ReadOnly {
    override val presetWatermarkId: Optional[PresetWatermarkId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.presetWatermarkId())
        .map(value =>
          zio.aws.elastictranscoder.model.primitives.PresetWatermarkId(value)
        )
    override val inputKey: Optional[WatermarkKey] = zio.aws.core.internal
      .optionalFromNullable(impl.inputKey())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.WatermarkKey(value)
      )
    override val encryption
        : Optional[zio.aws.elastictranscoder.model.Encryption.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryption())
        .map(value => zio.aws.elastictranscoder.model.Encryption.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.JobWatermark
  ): zio.aws.elastictranscoder.model.JobWatermark.ReadOnly = new Wrapper(impl)
}
