package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ReadJobResponse(
    job: Option[zio.aws.elastictranscoder.model.Job] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.ReadJobResponse = {
    import ReadJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.ReadJobResponse
      .builder()
      .optionallyWith(job.map(value => value.buildAwsValue()))(_.job)
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.ReadJobResponse.ReadOnly =
    zio.aws.elastictranscoder.model.ReadJobResponse.wrap(buildAwsValue())
}
object ReadJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.ReadJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.ReadJobResponse =
      zio.aws.elastictranscoder.model
        .ReadJobResponse(job.map(value => value.asEditable))
    def job: Option[zio.aws.elastictranscoder.model.Job.ReadOnly]
    def getJob
        : ZIO[Any, AwsError, zio.aws.elastictranscoder.model.Job.ReadOnly] =
      AwsError.unwrapOptionField("job", job)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.ReadJobResponse
  ) extends zio.aws.elastictranscoder.model.ReadJobResponse.ReadOnly {
    override val job: Option[zio.aws.elastictranscoder.model.Job.ReadOnly] =
      scala
        .Option(impl.job())
        .map(value => zio.aws.elastictranscoder.model.Job.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.ReadJobResponse
  ): zio.aws.elastictranscoder.model.ReadJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
