package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elastictranscoder.model.primitives.{JobStatus, Key, Id}
import scala.jdk.CollectionConverters._
final case class Job(
    id: Option[Id] = None,
    arn: Option[String] = None,
    pipelineId: Option[Id] = None,
    input: Option[zio.aws.elastictranscoder.model.JobInput] = None,
    inputs: Option[Iterable[zio.aws.elastictranscoder.model.JobInput]] = None,
    output: Option[zio.aws.elastictranscoder.model.JobOutput] = None,
    outputs: Option[Iterable[zio.aws.elastictranscoder.model.JobOutput]] = None,
    outputKeyPrefix: Option[Key] = None,
    playlists: Option[Iterable[zio.aws.elastictranscoder.model.Playlist]] =
      None,
    status: Option[JobStatus] = None,
    userMetadata: Option[Map[String, String]] = None,
    timing: Option[zio.aws.elastictranscoder.model.Timing] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.Job = {
    import Job.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.Job
      .builder()
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(
        pipelineId.map(value => Id.unwrap(value): java.lang.String)
      )(_.pipelineId)
      .optionallyWith(input.map(value => value.buildAwsValue()))(_.input)
      .optionallyWith(
        inputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputs)
      .optionallyWith(output.map(value => value.buildAwsValue()))(_.output)
      .optionallyWith(
        outputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputs)
      .optionallyWith(
        outputKeyPrefix.map(value => Key.unwrap(value): java.lang.String)
      )(_.outputKeyPrefix)
      .optionallyWith(
        playlists.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.playlists)
      .optionallyWith(
        status.map(value => JobStatus.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        userMetadata.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.userMetadata)
      .optionallyWith(timing.map(value => value.buildAwsValue()))(_.timing)
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.Job.ReadOnly =
    zio.aws.elastictranscoder.model.Job.wrap(buildAwsValue())
}
object Job {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.Job
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.Job =
      zio.aws.elastictranscoder.model.Job(
        id.map(value => value),
        arn.map(value => value),
        pipelineId.map(value => value),
        input.map(value => value.asEditable),
        inputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        output.map(value => value.asEditable),
        outputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        outputKeyPrefix.map(value => value),
        playlists.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        status.map(value => value),
        userMetadata.map(value => value),
        timing.map(value => value.asEditable)
      )
    def id: Option[Id]
    def arn: Option[String]
    def pipelineId: Option[Id]
    def input: Option[zio.aws.elastictranscoder.model.JobInput.ReadOnly]
    def inputs: Option[List[zio.aws.elastictranscoder.model.JobInput.ReadOnly]]
    def output: Option[zio.aws.elastictranscoder.model.JobOutput.ReadOnly]
    def outputs
        : Option[List[zio.aws.elastictranscoder.model.JobOutput.ReadOnly]]
    def outputKeyPrefix: Option[Key]
    def playlists
        : Option[List[zio.aws.elastictranscoder.model.Playlist.ReadOnly]]
    def status: Option[JobStatus]
    def userMetadata: Option[Map[String, String]]
    def timing: Option[zio.aws.elastictranscoder.model.Timing.ReadOnly]
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getPipelineId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("pipelineId", pipelineId)
    def getInput: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.JobInput.ReadOnly
    ] = AwsError.unwrapOptionField("input", input)
    def getInputs: ZIO[Any, AwsError, List[
      zio.aws.elastictranscoder.model.JobInput.ReadOnly
    ]] = AwsError.unwrapOptionField("inputs", inputs)
    def getOutput: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.JobOutput.ReadOnly
    ] = AwsError.unwrapOptionField("output", output)
    def getOutputs: ZIO[Any, AwsError, List[
      zio.aws.elastictranscoder.model.JobOutput.ReadOnly
    ]] = AwsError.unwrapOptionField("outputs", outputs)
    def getOutputKeyPrefix: ZIO[Any, AwsError, Key] =
      AwsError.unwrapOptionField("outputKeyPrefix", outputKeyPrefix)
    def getPlaylists: ZIO[Any, AwsError, List[
      zio.aws.elastictranscoder.model.Playlist.ReadOnly
    ]] = AwsError.unwrapOptionField("playlists", playlists)
    def getStatus: ZIO[Any, AwsError, JobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getUserMetadata: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("userMetadata", userMetadata)
    def getTiming
        : ZIO[Any, AwsError, zio.aws.elastictranscoder.model.Timing.ReadOnly] =
      AwsError.unwrapOptionField("timing", timing)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.Job
  ) extends zio.aws.elastictranscoder.model.Job.ReadOnly {
    override val id: Option[Id] = scala
      .Option(impl.id())
      .map(value => zio.aws.elastictranscoder.model.primitives.Id(value))
    override val arn: Option[String] =
      scala.Option(impl.arn()).map(value => value: String)
    override val pipelineId: Option[Id] = scala
      .Option(impl.pipelineId())
      .map(value => zio.aws.elastictranscoder.model.primitives.Id(value))
    override val input
        : Option[zio.aws.elastictranscoder.model.JobInput.ReadOnly] = scala
      .Option(impl.input())
      .map(value => zio.aws.elastictranscoder.model.JobInput.wrap(value))
    override val inputs
        : Option[List[zio.aws.elastictranscoder.model.JobInput.ReadOnly]] =
      scala
        .Option(impl.inputs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elastictranscoder.model.JobInput.wrap(item)
          }.toList
        )
    override val output
        : Option[zio.aws.elastictranscoder.model.JobOutput.ReadOnly] = scala
      .Option(impl.output())
      .map(value => zio.aws.elastictranscoder.model.JobOutput.wrap(value))
    override val outputs
        : Option[List[zio.aws.elastictranscoder.model.JobOutput.ReadOnly]] =
      scala
        .Option(impl.outputs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elastictranscoder.model.JobOutput.wrap(item)
          }.toList
        )
    override val outputKeyPrefix: Option[Key] = scala
      .Option(impl.outputKeyPrefix())
      .map(value => zio.aws.elastictranscoder.model.primitives.Key(value))
    override val playlists
        : Option[List[zio.aws.elastictranscoder.model.Playlist.ReadOnly]] =
      scala
        .Option(impl.playlists())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elastictranscoder.model.Playlist.wrap(item)
          }.toList
        )
    override val status: Option[JobStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.elastictranscoder.model.primitives.JobStatus(value))
    override val userMetadata: Option[Map[String, String]] = scala
      .Option(impl.userMetadata())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val timing
        : Option[zio.aws.elastictranscoder.model.Timing.ReadOnly] = scala
      .Option(impl.timing())
      .map(value => zio.aws.elastictranscoder.model.Timing.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.Job
  ): zio.aws.elastictranscoder.model.Job.ReadOnly = new Wrapper(impl)
}
