package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elastictranscoder.model.primitives.{
  CaptionFormatPattern,
  CaptionFormatFormat
}
import scala.jdk.CollectionConverters._
final case class CaptionFormat(
    format: Option[CaptionFormatFormat] = None,
    pattern: Option[CaptionFormatPattern] = None,
    encryption: Option[zio.aws.elastictranscoder.model.Encryption] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.CaptionFormat = {
    import CaptionFormat.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.CaptionFormat
      .builder()
      .optionallyWith(
        format.map(value => CaptionFormatFormat.unwrap(value): java.lang.String)
      )(_.format)
      .optionallyWith(
        pattern.map(value =>
          CaptionFormatPattern.unwrap(value): java.lang.String
        )
      )(_.pattern)
      .optionallyWith(encryption.map(value => value.buildAwsValue()))(
        _.encryption
      )
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.CaptionFormat.ReadOnly =
    zio.aws.elastictranscoder.model.CaptionFormat.wrap(buildAwsValue())
}
object CaptionFormat {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.CaptionFormat
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.CaptionFormat =
      zio.aws.elastictranscoder.model.CaptionFormat(
        format.map(value => value),
        pattern.map(value => value),
        encryption.map(value => value.asEditable)
      )
    def format: Option[CaptionFormatFormat]
    def pattern: Option[CaptionFormatPattern]
    def encryption: Option[zio.aws.elastictranscoder.model.Encryption.ReadOnly]
    def getFormat: ZIO[Any, AwsError, CaptionFormatFormat] =
      AwsError.unwrapOptionField("format", format)
    def getPattern: ZIO[Any, AwsError, CaptionFormatPattern] =
      AwsError.unwrapOptionField("pattern", pattern)
    def getEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.Encryption.ReadOnly
    ] = AwsError.unwrapOptionField("encryption", encryption)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.CaptionFormat
  ) extends zio.aws.elastictranscoder.model.CaptionFormat.ReadOnly {
    override val format: Option[CaptionFormatFormat] = scala
      .Option(impl.format())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.CaptionFormatFormat(value)
      )
    override val pattern: Option[CaptionFormatPattern] = scala
      .Option(impl.pattern())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.CaptionFormatPattern(value)
      )
    override val encryption
        : Option[zio.aws.elastictranscoder.model.Encryption.ReadOnly] = scala
      .Option(impl.encryption())
      .map(value => zio.aws.elastictranscoder.model.Encryption.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.CaptionFormat
  ): zio.aws.elastictranscoder.model.CaptionFormat.ReadOnly = new Wrapper(impl)
}
