package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elastictranscoder.model.primitives.{
  AudioSigned,
  AudioBitOrder,
  AudioBitDepth,
  AudioCodecProfile
}
import scala.jdk.CollectionConverters._
final case class AudioCodecOptions(
    profile: Option[AudioCodecProfile] = None,
    bitDepth: Option[AudioBitDepth] = None,
    bitOrder: Option[AudioBitOrder] = None,
    signed: Option[AudioSigned] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.AudioCodecOptions = {
    import AudioCodecOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.AudioCodecOptions
      .builder()
      .optionallyWith(
        profile.map(value => AudioCodecProfile.unwrap(value): java.lang.String)
      )(_.profile)
      .optionallyWith(
        bitDepth.map(value => AudioBitDepth.unwrap(value): java.lang.String)
      )(_.bitDepth)
      .optionallyWith(
        bitOrder.map(value => AudioBitOrder.unwrap(value): java.lang.String)
      )(_.bitOrder)
      .optionallyWith(
        signed.map(value => AudioSigned.unwrap(value): java.lang.String)
      )(_.signed)
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.AudioCodecOptions.ReadOnly =
    zio.aws.elastictranscoder.model.AudioCodecOptions.wrap(buildAwsValue())
}
object AudioCodecOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.AudioCodecOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.AudioCodecOptions =
      zio.aws.elastictranscoder.model.AudioCodecOptions(
        profile.map(value => value),
        bitDepth.map(value => value),
        bitOrder.map(value => value),
        signed.map(value => value)
      )
    def profile: Option[AudioCodecProfile]
    def bitDepth: Option[AudioBitDepth]
    def bitOrder: Option[AudioBitOrder]
    def signed: Option[AudioSigned]
    def getProfile: ZIO[Any, AwsError, AudioCodecProfile] =
      AwsError.unwrapOptionField("profile", profile)
    def getBitDepth: ZIO[Any, AwsError, AudioBitDepth] =
      AwsError.unwrapOptionField("bitDepth", bitDepth)
    def getBitOrder: ZIO[Any, AwsError, AudioBitOrder] =
      AwsError.unwrapOptionField("bitOrder", bitOrder)
    def getSigned: ZIO[Any, AwsError, AudioSigned] =
      AwsError.unwrapOptionField("signed", signed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.AudioCodecOptions
  ) extends zio.aws.elastictranscoder.model.AudioCodecOptions.ReadOnly {
    override val profile: Option[AudioCodecProfile] = scala
      .Option(impl.profile())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.AudioCodecProfile(value)
      )
    override val bitDepth: Option[AudioBitDepth] = scala
      .Option(impl.bitDepth())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.AudioBitDepth(value)
      )
    override val bitOrder: Option[AudioBitOrder] = scala
      .Option(impl.bitOrder())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.AudioBitOrder(value)
      )
    override val signed: Option[AudioSigned] = scala
      .Option(impl.signed())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.AudioSigned(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.AudioCodecOptions
  ): zio.aws.elastictranscoder.model.AudioCodecOptions.ReadOnly = new Wrapper(
    impl
  )
}
