package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elastictranscoder.model.primitives.Id
import scala.jdk.CollectionConverters._
final case class ListPipelinesResponse(
    pipelines: Option[Iterable[zio.aws.elastictranscoder.model.Pipeline]] =
      None,
    nextPageToken: Option[Id] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.ListPipelinesResponse = {
    import ListPipelinesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.ListPipelinesResponse
      .builder()
      .optionallyWith(
        pipelines.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pipelines)
      .optionallyWith(
        nextPageToken.map(value => Id.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elastictranscoder.model.ListPipelinesResponse.ReadOnly =
    zio.aws.elastictranscoder.model.ListPipelinesResponse.wrap(buildAwsValue())
}
object ListPipelinesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.ListPipelinesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.ListPipelinesResponse =
      zio.aws.elastictranscoder.model.ListPipelinesResponse(
        pipelines.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def pipelines
        : Option[List[zio.aws.elastictranscoder.model.Pipeline.ReadOnly]]
    def nextPageToken: Option[Id]
    def getPipelines: ZIO[Any, AwsError, List[
      zio.aws.elastictranscoder.model.Pipeline.ReadOnly
    ]] = AwsError.unwrapOptionField("pipelines", pipelines)
    def getNextPageToken: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.ListPipelinesResponse
  ) extends zio.aws.elastictranscoder.model.ListPipelinesResponse.ReadOnly {
    override val pipelines
        : Option[List[zio.aws.elastictranscoder.model.Pipeline.ReadOnly]] =
      scala
        .Option(impl.pipelines())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elastictranscoder.model.Pipeline.wrap(item)
          }.toList
        )
    override val nextPageToken: Option[Id] = scala
      .Option(impl.nextPageToken())
      .map(value => zio.aws.elastictranscoder.model.primitives.Id(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.ListPipelinesResponse
  ): zio.aws.elastictranscoder.model.ListPipelinesResponse.ReadOnly =
    new Wrapper(impl)
}
