package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elastictranscoder.model.primitives.{
  Key,
  PlaylistFormat,
  Filename
}
import scala.jdk.CollectionConverters._
final case class CreateJobPlaylist(
    name: Option[Filename] = None,
    format: Option[PlaylistFormat] = None,
    outputKeys: Option[Iterable[Key]] = None,
    hlsContentProtection: Option[
      zio.aws.elastictranscoder.model.HlsContentProtection
    ] = None,
    playReadyDrm: Option[zio.aws.elastictranscoder.model.PlayReadyDrm] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.CreateJobPlaylist = {
    import CreateJobPlaylist.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.CreateJobPlaylist
      .builder()
      .optionallyWith(
        name.map(value => Filename.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        format.map(value => PlaylistFormat.unwrap(value): java.lang.String)
      )(_.format)
      .optionallyWith(
        outputKeys.map(value =>
          value.map { item =>
            Key.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.outputKeys)
      .optionallyWith(hlsContentProtection.map(value => value.buildAwsValue()))(
        _.hlsContentProtection
      )
      .optionallyWith(playReadyDrm.map(value => value.buildAwsValue()))(
        _.playReadyDrm
      )
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.CreateJobPlaylist.ReadOnly =
    zio.aws.elastictranscoder.model.CreateJobPlaylist.wrap(buildAwsValue())
}
object CreateJobPlaylist {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.CreateJobPlaylist
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.CreateJobPlaylist =
      zio.aws.elastictranscoder.model.CreateJobPlaylist(
        name.map(value => value),
        format.map(value => value),
        outputKeys.map(value => value),
        hlsContentProtection.map(value => value.asEditable),
        playReadyDrm.map(value => value.asEditable)
      )
    def name: Option[Filename]
    def format: Option[PlaylistFormat]
    def outputKeys: Option[List[Key]]
    def hlsContentProtection
        : Option[zio.aws.elastictranscoder.model.HlsContentProtection.ReadOnly]
    def playReadyDrm
        : Option[zio.aws.elastictranscoder.model.PlayReadyDrm.ReadOnly]
    def getName: ZIO[Any, AwsError, Filename] =
      AwsError.unwrapOptionField("name", name)
    def getFormat: ZIO[Any, AwsError, PlaylistFormat] =
      AwsError.unwrapOptionField("format", format)
    def getOutputKeys: ZIO[Any, AwsError, List[Key]] =
      AwsError.unwrapOptionField("outputKeys", outputKeys)
    def getHlsContentProtection: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.HlsContentProtection.ReadOnly
    ] = AwsError.unwrapOptionField("hlsContentProtection", hlsContentProtection)
    def getPlayReadyDrm: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.PlayReadyDrm.ReadOnly
    ] = AwsError.unwrapOptionField("playReadyDrm", playReadyDrm)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.CreateJobPlaylist
  ) extends zio.aws.elastictranscoder.model.CreateJobPlaylist.ReadOnly {
    override val name: Option[Filename] = scala
      .Option(impl.name())
      .map(value => zio.aws.elastictranscoder.model.primitives.Filename(value))
    override val format: Option[PlaylistFormat] = scala
      .Option(impl.format())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.PlaylistFormat(value)
      )
    override val outputKeys: Option[List[Key]] = scala
      .Option(impl.outputKeys())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elastictranscoder.model.primitives.Key(item)
        }.toList
      )
    override val hlsContentProtection: Option[
      zio.aws.elastictranscoder.model.HlsContentProtection.ReadOnly
    ] = scala
      .Option(impl.hlsContentProtection())
      .map(value =>
        zio.aws.elastictranscoder.model.HlsContentProtection.wrap(value)
      )
    override val playReadyDrm
        : Option[zio.aws.elastictranscoder.model.PlayReadyDrm.ReadOnly] = scala
      .Option(impl.playReadyDrm())
      .map(value => zio.aws.elastictranscoder.model.PlayReadyDrm.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.CreateJobPlaylist
  ): zio.aws.elastictranscoder.model.CreateJobPlaylist.ReadOnly = new Wrapper(
    impl
  )
}
