package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elastictranscoder.model.primitives.{
  KeyArn,
  BucketName,
  Name,
  Role,
  Id
}
import scala.jdk.CollectionConverters._
final case class UpdatePipelineRequest(
    id: Id,
    name: Option[Name] = None,
    inputBucket: Option[BucketName] = None,
    role: Option[Role] = None,
    awsKmsKeyArn: Option[KeyArn] = None,
    notifications: Option[zio.aws.elastictranscoder.model.Notifications] = None,
    contentConfig: Option[
      zio.aws.elastictranscoder.model.PipelineOutputConfig
    ] = None,
    thumbnailConfig: Option[
      zio.aws.elastictranscoder.model.PipelineOutputConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineRequest = {
    import UpdatePipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineRequest
      .builder()
      .id(Id.unwrap(id): java.lang.String)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        inputBucket.map(value => BucketName.unwrap(value): java.lang.String)
      )(_.inputBucket)
      .optionallyWith(role.map(value => Role.unwrap(value): java.lang.String))(
        _.role
      )
      .optionallyWith(
        awsKmsKeyArn.map(value => KeyArn.unwrap(value): java.lang.String)
      )(_.awsKmsKeyArn)
      .optionallyWith(notifications.map(value => value.buildAwsValue()))(
        _.notifications
      )
      .optionallyWith(contentConfig.map(value => value.buildAwsValue()))(
        _.contentConfig
      )
      .optionallyWith(thumbnailConfig.map(value => value.buildAwsValue()))(
        _.thumbnailConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elastictranscoder.model.UpdatePipelineRequest.ReadOnly =
    zio.aws.elastictranscoder.model.UpdatePipelineRequest.wrap(buildAwsValue())
}
object UpdatePipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.UpdatePipelineRequest =
      zio.aws.elastictranscoder.model.UpdatePipelineRequest(
        id,
        name.map(value => value),
        inputBucket.map(value => value),
        role.map(value => value),
        awsKmsKeyArn.map(value => value),
        notifications.map(value => value.asEditable),
        contentConfig.map(value => value.asEditable),
        thumbnailConfig.map(value => value.asEditable)
      )
    def id: Id
    def name: Option[Name]
    def inputBucket: Option[BucketName]
    def role: Option[Role]
    def awsKmsKeyArn: Option[KeyArn]
    def notifications
        : Option[zio.aws.elastictranscoder.model.Notifications.ReadOnly]
    def contentConfig
        : Option[zio.aws.elastictranscoder.model.PipelineOutputConfig.ReadOnly]
    def thumbnailConfig
        : Option[zio.aws.elastictranscoder.model.PipelineOutputConfig.ReadOnly]
    def getId: ZIO[Any, Nothing, Id] = ZIO.succeed(id)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getInputBucket: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("inputBucket", inputBucket)
    def getRole: ZIO[Any, AwsError, Role] =
      AwsError.unwrapOptionField("role", role)
    def getAwsKmsKeyArn: ZIO[Any, AwsError, KeyArn] =
      AwsError.unwrapOptionField("awsKmsKeyArn", awsKmsKeyArn)
    def getNotifications: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.Notifications.ReadOnly
    ] = AwsError.unwrapOptionField("notifications", notifications)
    def getContentConfig: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.PipelineOutputConfig.ReadOnly
    ] = AwsError.unwrapOptionField("contentConfig", contentConfig)
    def getThumbnailConfig: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.PipelineOutputConfig.ReadOnly
    ] = AwsError.unwrapOptionField("thumbnailConfig", thumbnailConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineRequest
  ) extends zio.aws.elastictranscoder.model.UpdatePipelineRequest.ReadOnly {
    override val id: Id =
      zio.aws.elastictranscoder.model.primitives.Id(impl.id())
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.elastictranscoder.model.primitives.Name(value))
    override val inputBucket: Option[BucketName] = scala
      .Option(impl.inputBucket())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.BucketName(value)
      )
    override val role: Option[Role] = scala
      .Option(impl.role())
      .map(value => zio.aws.elastictranscoder.model.primitives.Role(value))
    override val awsKmsKeyArn: Option[KeyArn] = scala
      .Option(impl.awsKmsKeyArn())
      .map(value => zio.aws.elastictranscoder.model.primitives.KeyArn(value))
    override val notifications
        : Option[zio.aws.elastictranscoder.model.Notifications.ReadOnly] = scala
      .Option(impl.notifications())
      .map(value => zio.aws.elastictranscoder.model.Notifications.wrap(value))
    override val contentConfig: Option[
      zio.aws.elastictranscoder.model.PipelineOutputConfig.ReadOnly
    ] = scala
      .Option(impl.contentConfig())
      .map(value =>
        zio.aws.elastictranscoder.model.PipelineOutputConfig.wrap(value)
      )
    override val thumbnailConfig: Option[
      zio.aws.elastictranscoder.model.PipelineOutputConfig.ReadOnly
    ] = scala
      .Option(impl.thumbnailConfig())
      .map(value =>
        zio.aws.elastictranscoder.model.PipelineOutputConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineRequest
  ): zio.aws.elastictranscoder.model.UpdatePipelineRequest.ReadOnly =
    new Wrapper(impl)
}
