package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elastictranscoder.model.primitives.{
  KeyIdGuid,
  PlayReadyDrmFormatString,
  NonEmptyBase64EncodedString,
  ZeroTo255String,
  OneTo512String
}
import scala.jdk.CollectionConverters._
final case class PlayReadyDrm(
    format: Option[PlayReadyDrmFormatString] = None,
    key: Option[NonEmptyBase64EncodedString] = None,
    keyMd5: Option[NonEmptyBase64EncodedString] = None,
    keyId: Option[KeyIdGuid] = None,
    initializationVector: Option[ZeroTo255String] = None,
    licenseAcquisitionUrl: Option[OneTo512String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.PlayReadyDrm = {
    import PlayReadyDrm.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.PlayReadyDrm
      .builder()
      .optionallyWith(
        format.map(value =>
          PlayReadyDrmFormatString.unwrap(value): java.lang.String
        )
      )(_.format)
      .optionallyWith(
        key.map(value =>
          NonEmptyBase64EncodedString.unwrap(value): java.lang.String
        )
      )(_.key)
      .optionallyWith(
        keyMd5.map(value =>
          NonEmptyBase64EncodedString.unwrap(value): java.lang.String
        )
      )(_.keyMd5)
      .optionallyWith(
        keyId.map(value => KeyIdGuid.unwrap(value): java.lang.String)
      )(_.keyId)
      .optionallyWith(
        initializationVector.map(value =>
          ZeroTo255String.unwrap(value): java.lang.String
        )
      )(_.initializationVector)
      .optionallyWith(
        licenseAcquisitionUrl.map(value =>
          OneTo512String.unwrap(value): java.lang.String
        )
      )(_.licenseAcquisitionUrl)
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.PlayReadyDrm.ReadOnly =
    zio.aws.elastictranscoder.model.PlayReadyDrm.wrap(buildAwsValue())
}
object PlayReadyDrm {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.PlayReadyDrm
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.PlayReadyDrm =
      zio.aws.elastictranscoder.model.PlayReadyDrm(
        format.map(value => value),
        key.map(value => value),
        keyMd5.map(value => value),
        keyId.map(value => value),
        initializationVector.map(value => value),
        licenseAcquisitionUrl.map(value => value)
      )
    def format: Option[PlayReadyDrmFormatString]
    def key: Option[NonEmptyBase64EncodedString]
    def keyMd5: Option[NonEmptyBase64EncodedString]
    def keyId: Option[KeyIdGuid]
    def initializationVector: Option[ZeroTo255String]
    def licenseAcquisitionUrl: Option[OneTo512String]
    def getFormat: ZIO[Any, AwsError, PlayReadyDrmFormatString] =
      AwsError.unwrapOptionField("format", format)
    def getKey: ZIO[Any, AwsError, NonEmptyBase64EncodedString] =
      AwsError.unwrapOptionField("key", key)
    def getKeyMd5: ZIO[Any, AwsError, NonEmptyBase64EncodedString] =
      AwsError.unwrapOptionField("keyMd5", keyMd5)
    def getKeyId: ZIO[Any, AwsError, KeyIdGuid] =
      AwsError.unwrapOptionField("keyId", keyId)
    def getInitializationVector: ZIO[Any, AwsError, ZeroTo255String] =
      AwsError.unwrapOptionField("initializationVector", initializationVector)
    def getLicenseAcquisitionUrl: ZIO[Any, AwsError, OneTo512String] =
      AwsError.unwrapOptionField("licenseAcquisitionUrl", licenseAcquisitionUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.PlayReadyDrm
  ) extends zio.aws.elastictranscoder.model.PlayReadyDrm.ReadOnly {
    override val format: Option[PlayReadyDrmFormatString] = scala
      .Option(impl.format())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives
          .PlayReadyDrmFormatString(value)
      )
    override val key: Option[NonEmptyBase64EncodedString] = scala
      .Option(impl.key())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives
          .NonEmptyBase64EncodedString(value)
      )
    override val keyMd5: Option[NonEmptyBase64EncodedString] = scala
      .Option(impl.keyMd5())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives
          .NonEmptyBase64EncodedString(value)
      )
    override val keyId: Option[KeyIdGuid] = scala
      .Option(impl.keyId())
      .map(value => zio.aws.elastictranscoder.model.primitives.KeyIdGuid(value))
    override val initializationVector: Option[ZeroTo255String] = scala
      .Option(impl.initializationVector())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.ZeroTo255String(value)
      )
    override val licenseAcquisitionUrl: Option[OneTo512String] = scala
      .Option(impl.licenseAcquisitionUrl())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.OneTo512String(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.PlayReadyDrm
  ): zio.aws.elastictranscoder.model.PlayReadyDrm.ReadOnly = new Wrapper(impl)
}
