package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elastictranscoder.model.primitives.{
  PipelineStatus,
  KeyArn,
  BucketName,
  Name,
  Role,
  Id
}
import scala.jdk.CollectionConverters._
final case class Pipeline(
    id: Option[Id] = None,
    arn: Option[String] = None,
    name: Option[Name] = None,
    status: Option[PipelineStatus] = None,
    inputBucket: Option[BucketName] = None,
    outputBucket: Option[BucketName] = None,
    role: Option[Role] = None,
    awsKmsKeyArn: Option[KeyArn] = None,
    notifications: Option[zio.aws.elastictranscoder.model.Notifications] = None,
    contentConfig: Option[
      zio.aws.elastictranscoder.model.PipelineOutputConfig
    ] = None,
    thumbnailConfig: Option[
      zio.aws.elastictranscoder.model.PipelineOutputConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.Pipeline = {
    import Pipeline.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.Pipeline
      .builder()
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        status.map(value => PipelineStatus.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        inputBucket.map(value => BucketName.unwrap(value): java.lang.String)
      )(_.inputBucket)
      .optionallyWith(
        outputBucket.map(value => BucketName.unwrap(value): java.lang.String)
      )(_.outputBucket)
      .optionallyWith(role.map(value => Role.unwrap(value): java.lang.String))(
        _.role
      )
      .optionallyWith(
        awsKmsKeyArn.map(value => KeyArn.unwrap(value): java.lang.String)
      )(_.awsKmsKeyArn)
      .optionallyWith(notifications.map(value => value.buildAwsValue()))(
        _.notifications
      )
      .optionallyWith(contentConfig.map(value => value.buildAwsValue()))(
        _.contentConfig
      )
      .optionallyWith(thumbnailConfig.map(value => value.buildAwsValue()))(
        _.thumbnailConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.Pipeline.ReadOnly =
    zio.aws.elastictranscoder.model.Pipeline.wrap(buildAwsValue())
}
object Pipeline {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.Pipeline
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.Pipeline =
      zio.aws.elastictranscoder.model.Pipeline(
        id.map(value => value),
        arn.map(value => value),
        name.map(value => value),
        status.map(value => value),
        inputBucket.map(value => value),
        outputBucket.map(value => value),
        role.map(value => value),
        awsKmsKeyArn.map(value => value),
        notifications.map(value => value.asEditable),
        contentConfig.map(value => value.asEditable),
        thumbnailConfig.map(value => value.asEditable)
      )
    def id: Option[Id]
    def arn: Option[String]
    def name: Option[Name]
    def status: Option[PipelineStatus]
    def inputBucket: Option[BucketName]
    def outputBucket: Option[BucketName]
    def role: Option[Role]
    def awsKmsKeyArn: Option[KeyArn]
    def notifications
        : Option[zio.aws.elastictranscoder.model.Notifications.ReadOnly]
    def contentConfig
        : Option[zio.aws.elastictranscoder.model.PipelineOutputConfig.ReadOnly]
    def thumbnailConfig
        : Option[zio.aws.elastictranscoder.model.PipelineOutputConfig.ReadOnly]
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, AwsError, PipelineStatus] =
      AwsError.unwrapOptionField("status", status)
    def getInputBucket: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("inputBucket", inputBucket)
    def getOutputBucket: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("outputBucket", outputBucket)
    def getRole: ZIO[Any, AwsError, Role] =
      AwsError.unwrapOptionField("role", role)
    def getAwsKmsKeyArn: ZIO[Any, AwsError, KeyArn] =
      AwsError.unwrapOptionField("awsKmsKeyArn", awsKmsKeyArn)
    def getNotifications: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.Notifications.ReadOnly
    ] = AwsError.unwrapOptionField("notifications", notifications)
    def getContentConfig: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.PipelineOutputConfig.ReadOnly
    ] = AwsError.unwrapOptionField("contentConfig", contentConfig)
    def getThumbnailConfig: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.PipelineOutputConfig.ReadOnly
    ] = AwsError.unwrapOptionField("thumbnailConfig", thumbnailConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.Pipeline
  ) extends zio.aws.elastictranscoder.model.Pipeline.ReadOnly {
    override val id: Option[Id] = scala
      .Option(impl.id())
      .map(value => zio.aws.elastictranscoder.model.primitives.Id(value))
    override val arn: Option[String] =
      scala.Option(impl.arn()).map(value => value: String)
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.elastictranscoder.model.primitives.Name(value))
    override val status: Option[PipelineStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.PipelineStatus(value)
      )
    override val inputBucket: Option[BucketName] = scala
      .Option(impl.inputBucket())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.BucketName(value)
      )
    override val outputBucket: Option[BucketName] = scala
      .Option(impl.outputBucket())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.BucketName(value)
      )
    override val role: Option[Role] = scala
      .Option(impl.role())
      .map(value => zio.aws.elastictranscoder.model.primitives.Role(value))
    override val awsKmsKeyArn: Option[KeyArn] = scala
      .Option(impl.awsKmsKeyArn())
      .map(value => zio.aws.elastictranscoder.model.primitives.KeyArn(value))
    override val notifications
        : Option[zio.aws.elastictranscoder.model.Notifications.ReadOnly] = scala
      .Option(impl.notifications())
      .map(value => zio.aws.elastictranscoder.model.Notifications.wrap(value))
    override val contentConfig: Option[
      zio.aws.elastictranscoder.model.PipelineOutputConfig.ReadOnly
    ] = scala
      .Option(impl.contentConfig())
      .map(value =>
        zio.aws.elastictranscoder.model.PipelineOutputConfig.wrap(value)
      )
    override val thumbnailConfig: Option[
      zio.aws.elastictranscoder.model.PipelineOutputConfig.ReadOnly
    ] = scala
      .Option(impl.thumbnailConfig())
      .map(value =>
        zio.aws.elastictranscoder.model.PipelineOutputConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.Pipeline
  ): zio.aws.elastictranscoder.model.Pipeline.ReadOnly = new Wrapper(impl)
}
