package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.elastictranscoder.model.primitives.Id
import scala.jdk.CollectionConverters._
final case class ReadPipelineRequest(id: Id) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.ReadPipelineRequest = {
    import ReadPipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.ReadPipelineRequest
      .builder()
      .id(Id.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.ReadPipelineRequest.ReadOnly =
    zio.aws.elastictranscoder.model.ReadPipelineRequest.wrap(buildAwsValue())
}
object ReadPipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.ReadPipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.ReadPipelineRequest =
      zio.aws.elastictranscoder.model.ReadPipelineRequest(id)
    def id: Id
    def getId: ZIO[Any, Nothing, Id] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.ReadPipelineRequest
  ) extends zio.aws.elastictranscoder.model.ReadPipelineRequest.ReadOnly {
    override val id: Id =
      zio.aws.elastictranscoder.model.primitives.Id(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.ReadPipelineRequest
  ): zio.aws.elastictranscoder.model.ReadPipelineRequest.ReadOnly = new Wrapper(
    impl
  )
}
