package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elastictranscoder.model.primitives.{
  PresetContainer,
  Description,
  Name
}
import scala.jdk.CollectionConverters._
final case class CreatePresetRequest(
    name: Name,
    description: Option[Description] = None,
    container: PresetContainer,
    video: Option[zio.aws.elastictranscoder.model.VideoParameters] = None,
    audio: Option[zio.aws.elastictranscoder.model.AudioParameters] = None,
    thumbnails: Option[zio.aws.elastictranscoder.model.Thumbnails] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.CreatePresetRequest = {
    import CreatePresetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.CreatePresetRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .container(PresetContainer.unwrap(container): java.lang.String)
      .optionallyWith(video.map(value => value.buildAwsValue()))(_.video)
      .optionallyWith(audio.map(value => value.buildAwsValue()))(_.audio)
      .optionallyWith(thumbnails.map(value => value.buildAwsValue()))(
        _.thumbnails
      )
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.CreatePresetRequest.ReadOnly =
    zio.aws.elastictranscoder.model.CreatePresetRequest.wrap(buildAwsValue())
}
object CreatePresetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.CreatePresetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.CreatePresetRequest =
      zio.aws.elastictranscoder.model.CreatePresetRequest(
        name,
        description.map(value => value),
        container,
        video.map(value => value.asEditable),
        audio.map(value => value.asEditable),
        thumbnails.map(value => value.asEditable)
      )
    def name: Name
    def description: Option[Description]
    def container: PresetContainer
    def video: Option[zio.aws.elastictranscoder.model.VideoParameters.ReadOnly]
    def audio: Option[zio.aws.elastictranscoder.model.AudioParameters.ReadOnly]
    def thumbnails: Option[zio.aws.elastictranscoder.model.Thumbnails.ReadOnly]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getContainer: ZIO[Any, Nothing, PresetContainer] =
      ZIO.succeed(container)
    def getVideo: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.VideoParameters.ReadOnly
    ] = AwsError.unwrapOptionField("video", video)
    def getAudio: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.AudioParameters.ReadOnly
    ] = AwsError.unwrapOptionField("audio", audio)
    def getThumbnails: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.Thumbnails.ReadOnly
    ] = AwsError.unwrapOptionField("thumbnails", thumbnails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.CreatePresetRequest
  ) extends zio.aws.elastictranscoder.model.CreatePresetRequest.ReadOnly {
    override val name: Name =
      zio.aws.elastictranscoder.model.primitives.Name(impl.name())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.Description(value)
      )
    override val container: PresetContainer =
      zio.aws.elastictranscoder.model.primitives
        .PresetContainer(impl.container())
    override val video
        : Option[zio.aws.elastictranscoder.model.VideoParameters.ReadOnly] =
      scala
        .Option(impl.video())
        .map(value =>
          zio.aws.elastictranscoder.model.VideoParameters.wrap(value)
        )
    override val audio
        : Option[zio.aws.elastictranscoder.model.AudioParameters.ReadOnly] =
      scala
        .Option(impl.audio())
        .map(value =>
          zio.aws.elastictranscoder.model.AudioParameters.wrap(value)
        )
    override val thumbnails
        : Option[zio.aws.elastictranscoder.model.Thumbnails.ReadOnly] = scala
      .Option(impl.thumbnails())
      .map(value => zio.aws.elastictranscoder.model.Thumbnails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.CreatePresetRequest
  ): zio.aws.elastictranscoder.model.CreatePresetRequest.ReadOnly = new Wrapper(
    impl
  )
}
