package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elastictranscoder.model.primitives.{
  DigitsOrAuto,
  JpgOrPng,
  WatermarkKey,
  PaddingPolicy,
  SizingPolicy
}
import scala.jdk.CollectionConverters._
final case class Artwork(
    inputKey: Option[WatermarkKey] = None,
    maxWidth: Option[DigitsOrAuto] = None,
    maxHeight: Option[DigitsOrAuto] = None,
    sizingPolicy: Option[SizingPolicy] = None,
    paddingPolicy: Option[PaddingPolicy] = None,
    albumArtFormat: Option[JpgOrPng] = None,
    encryption: Option[zio.aws.elastictranscoder.model.Encryption] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.Artwork = {
    import Artwork.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.Artwork
      .builder()
      .optionallyWith(
        inputKey.map(value => WatermarkKey.unwrap(value): java.lang.String)
      )(_.inputKey)
      .optionallyWith(
        maxWidth.map(value => DigitsOrAuto.unwrap(value): java.lang.String)
      )(_.maxWidth)
      .optionallyWith(
        maxHeight.map(value => DigitsOrAuto.unwrap(value): java.lang.String)
      )(_.maxHeight)
      .optionallyWith(
        sizingPolicy.map(value => SizingPolicy.unwrap(value): java.lang.String)
      )(_.sizingPolicy)
      .optionallyWith(
        paddingPolicy.map(value =>
          PaddingPolicy.unwrap(value): java.lang.String
        )
      )(_.paddingPolicy)
      .optionallyWith(
        albumArtFormat.map(value => JpgOrPng.unwrap(value): java.lang.String)
      )(_.albumArtFormat)
      .optionallyWith(encryption.map(value => value.buildAwsValue()))(
        _.encryption
      )
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.Artwork.ReadOnly =
    zio.aws.elastictranscoder.model.Artwork.wrap(buildAwsValue())
}
object Artwork {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.Artwork
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.Artwork =
      zio.aws.elastictranscoder.model.Artwork(
        inputKey.map(value => value),
        maxWidth.map(value => value),
        maxHeight.map(value => value),
        sizingPolicy.map(value => value),
        paddingPolicy.map(value => value),
        albumArtFormat.map(value => value),
        encryption.map(value => value.asEditable)
      )
    def inputKey: Option[WatermarkKey]
    def maxWidth: Option[DigitsOrAuto]
    def maxHeight: Option[DigitsOrAuto]
    def sizingPolicy: Option[SizingPolicy]
    def paddingPolicy: Option[PaddingPolicy]
    def albumArtFormat: Option[JpgOrPng]
    def encryption: Option[zio.aws.elastictranscoder.model.Encryption.ReadOnly]
    def getInputKey: ZIO[Any, AwsError, WatermarkKey] =
      AwsError.unwrapOptionField("inputKey", inputKey)
    def getMaxWidth: ZIO[Any, AwsError, DigitsOrAuto] =
      AwsError.unwrapOptionField("maxWidth", maxWidth)
    def getMaxHeight: ZIO[Any, AwsError, DigitsOrAuto] =
      AwsError.unwrapOptionField("maxHeight", maxHeight)
    def getSizingPolicy: ZIO[Any, AwsError, SizingPolicy] =
      AwsError.unwrapOptionField("sizingPolicy", sizingPolicy)
    def getPaddingPolicy: ZIO[Any, AwsError, PaddingPolicy] =
      AwsError.unwrapOptionField("paddingPolicy", paddingPolicy)
    def getAlbumArtFormat: ZIO[Any, AwsError, JpgOrPng] =
      AwsError.unwrapOptionField("albumArtFormat", albumArtFormat)
    def getEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.Encryption.ReadOnly
    ] = AwsError.unwrapOptionField("encryption", encryption)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.Artwork
  ) extends zio.aws.elastictranscoder.model.Artwork.ReadOnly {
    override val inputKey: Option[WatermarkKey] = scala
      .Option(impl.inputKey())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.WatermarkKey(value)
      )
    override val maxWidth: Option[DigitsOrAuto] = scala
      .Option(impl.maxWidth())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.DigitsOrAuto(value)
      )
    override val maxHeight: Option[DigitsOrAuto] = scala
      .Option(impl.maxHeight())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.DigitsOrAuto(value)
      )
    override val sizingPolicy: Option[SizingPolicy] = scala
      .Option(impl.sizingPolicy())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.SizingPolicy(value)
      )
    override val paddingPolicy: Option[PaddingPolicy] = scala
      .Option(impl.paddingPolicy())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.PaddingPolicy(value)
      )
    override val albumArtFormat: Option[JpgOrPng] = scala
      .Option(impl.albumArtFormat())
      .map(value => zio.aws.elastictranscoder.model.primitives.JpgOrPng(value))
    override val encryption
        : Option[zio.aws.elastictranscoder.model.Encryption.ReadOnly] = scala
      .Option(impl.encryption())
      .map(value => zio.aws.elastictranscoder.model.Encryption.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.Artwork
  ): zio.aws.elastictranscoder.model.Artwork.ReadOnly = new Wrapper(impl)
}
