package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elastictranscoder.model.primitives.{
  PresetType,
  PresetContainer,
  Description,
  Name,
  Id
}
import scala.jdk.CollectionConverters._
final case class Preset(
    id: Option[Id] = None,
    arn: Option[String] = None,
    name: Option[Name] = None,
    description: Option[Description] = None,
    container: Option[PresetContainer] = None,
    audio: Option[zio.aws.elastictranscoder.model.AudioParameters] = None,
    video: Option[zio.aws.elastictranscoder.model.VideoParameters] = None,
    thumbnails: Option[zio.aws.elastictranscoder.model.Thumbnails] = None,
    `type`: Option[PresetType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.Preset = {
    import Preset.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.Preset
      .builder()
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        container.map(value => PresetContainer.unwrap(value): java.lang.String)
      )(_.container)
      .optionallyWith(audio.map(value => value.buildAwsValue()))(_.audio)
      .optionallyWith(video.map(value => value.buildAwsValue()))(_.video)
      .optionallyWith(thumbnails.map(value => value.buildAwsValue()))(
        _.thumbnails
      )
      .optionallyWith(
        `type`.map(value => PresetType.unwrap(value): java.lang.String)
      )(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.Preset.ReadOnly =
    zio.aws.elastictranscoder.model.Preset.wrap(buildAwsValue())
}
object Preset {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.Preset
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.Preset =
      zio.aws.elastictranscoder.model.Preset(
        id.map(value => value),
        arn.map(value => value),
        name.map(value => value),
        description.map(value => value),
        container.map(value => value),
        audio.map(value => value.asEditable),
        video.map(value => value.asEditable),
        thumbnails.map(value => value.asEditable),
        `type`.map(value => value)
      )
    def id: Option[Id]
    def arn: Option[String]
    def name: Option[Name]
    def description: Option[Description]
    def container: Option[PresetContainer]
    def audio: Option[zio.aws.elastictranscoder.model.AudioParameters.ReadOnly]
    def video: Option[zio.aws.elastictranscoder.model.VideoParameters.ReadOnly]
    def thumbnails: Option[zio.aws.elastictranscoder.model.Thumbnails.ReadOnly]
    def `type`: Option[PresetType]
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getContainer: ZIO[Any, AwsError, PresetContainer] =
      AwsError.unwrapOptionField("container", container)
    def getAudio: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.AudioParameters.ReadOnly
    ] = AwsError.unwrapOptionField("audio", audio)
    def getVideo: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.VideoParameters.ReadOnly
    ] = AwsError.unwrapOptionField("video", video)
    def getThumbnails: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.Thumbnails.ReadOnly
    ] = AwsError.unwrapOptionField("thumbnails", thumbnails)
    def getType: ZIO[Any, AwsError, PresetType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.Preset
  ) extends zio.aws.elastictranscoder.model.Preset.ReadOnly {
    override val id: Option[Id] = scala
      .Option(impl.id())
      .map(value => zio.aws.elastictranscoder.model.primitives.Id(value))
    override val arn: Option[String] =
      scala.Option(impl.arn()).map(value => value: String)
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.elastictranscoder.model.primitives.Name(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.Description(value)
      )
    override val container: Option[PresetContainer] = scala
      .Option(impl.container())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.PresetContainer(value)
      )
    override val audio
        : Option[zio.aws.elastictranscoder.model.AudioParameters.ReadOnly] =
      scala
        .Option(impl.audio())
        .map(value =>
          zio.aws.elastictranscoder.model.AudioParameters.wrap(value)
        )
    override val video
        : Option[zio.aws.elastictranscoder.model.VideoParameters.ReadOnly] =
      scala
        .Option(impl.video())
        .map(value =>
          zio.aws.elastictranscoder.model.VideoParameters.wrap(value)
        )
    override val thumbnails
        : Option[zio.aws.elastictranscoder.model.Thumbnails.ReadOnly] = scala
      .Option(impl.thumbnails())
      .map(value => zio.aws.elastictranscoder.model.Thumbnails.wrap(value))
    override val `type`: Option[PresetType] = scala
      .Option(impl.`type`())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.PresetType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.Preset
  ): zio.aws.elastictranscoder.model.Preset.ReadOnly = new Wrapper(impl)
}
