package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elastictranscoder.model.primitives.{StorageClass, BucketName}
import scala.jdk.CollectionConverters._
final case class PipelineOutputConfig(
    bucket: Option[BucketName] = None,
    storageClass: Option[StorageClass] = None,
    permissions: Option[Iterable[zio.aws.elastictranscoder.model.Permission]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.PipelineOutputConfig = {
    import PipelineOutputConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.PipelineOutputConfig
      .builder()
      .optionallyWith(
        bucket.map(value => BucketName.unwrap(value): java.lang.String)
      )(_.bucket)
      .optionallyWith(
        storageClass.map(value => StorageClass.unwrap(value): java.lang.String)
      )(_.storageClass)
      .optionallyWith(
        permissions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.permissions)
      .build()
  }
  def asReadOnly
      : zio.aws.elastictranscoder.model.PipelineOutputConfig.ReadOnly =
    zio.aws.elastictranscoder.model.PipelineOutputConfig.wrap(buildAwsValue())
}
object PipelineOutputConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.PipelineOutputConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.PipelineOutputConfig =
      zio.aws.elastictranscoder.model.PipelineOutputConfig(
        bucket.map(value => value),
        storageClass.map(value => value),
        permissions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def bucket: Option[BucketName]
    def storageClass: Option[StorageClass]
    def permissions
        : Option[List[zio.aws.elastictranscoder.model.Permission.ReadOnly]]
    def getBucket: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getStorageClass: ZIO[Any, AwsError, StorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClass)
    def getPermissions: ZIO[Any, AwsError, List[
      zio.aws.elastictranscoder.model.Permission.ReadOnly
    ]] = AwsError.unwrapOptionField("permissions", permissions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.PipelineOutputConfig
  ) extends zio.aws.elastictranscoder.model.PipelineOutputConfig.ReadOnly {
    override val bucket: Option[BucketName] = scala
      .Option(impl.bucket())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.BucketName(value)
      )
    override val storageClass: Option[StorageClass] = scala
      .Option(impl.storageClass())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.StorageClass(value)
      )
    override val permissions
        : Option[List[zio.aws.elastictranscoder.model.Permission.ReadOnly]] =
      scala
        .Option(impl.permissions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elastictranscoder.model.Permission.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.PipelineOutputConfig
  ): zio.aws.elastictranscoder.model.PipelineOutputConfig.ReadOnly =
    new Wrapper(impl)
}
